/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.userstorage;

import nl.mpi.arbil.userstorage.ArbilConfiguration;
import nl.mpi.arbil.userstorage.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(ArbilConfigurationManager.class);
    public static final String VERBATIM_XML_TREE_STRUCTURE = "verbatimXmlTreeStructure";
    public static final String COPY_NEW_RESOURCES = "copyNewResources";
    private final SessionStorage sessionStorage;

    public ArbilConfigurationManager(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public synchronized ArbilConfiguration read() {
        logger.info("Reading configuration from session storage");
        ArbilConfiguration configuration = new ArbilConfiguration();
        configuration.setVerbatimXmlTreeStructure(this.sessionStorage.loadBoolean(VERBATIM_XML_TREE_STRUCTURE, false));
        configuration.setCopyNewResourcesToCache(this.sessionStorage.loadBoolean(COPY_NEW_RESOURCES, false));
        logger.debug("Finished reading configuration:\n{}", (Object)configuration);
        return configuration;
    }

    public synchronized void write(ArbilConfiguration configuration) {
        logger.info("Writing configuration to session storage");
        logger.debug("Writing configuration values:\n{}", (Object)configuration);
        this.sessionStorage.saveBoolean(VERBATIM_XML_TREE_STRUCTURE, configuration.isVerbatimXmlTreeStructure());
        this.sessionStorage.saveBoolean(COPY_NEW_RESOURCES, configuration.isCopyNewResourcesToCache());
        logger.debug("Finished writing configuration");
    }
}

