/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMetadataReader {
    private static final Logger logger = LoggerFactory.getLogger(BinaryMetadataReader.class);

    public ArbilField[] getExifMetadata(ArbilDataNode resourceNode, int currentFieldId) {
        ArrayList<ArbilField> exifTagFields = new ArrayList<ArbilField>();
        try {
            String fileSuffix;
            Iterator<ImageReader> readers;
            URI uri = resourceNode.getURI();
            if (resourceNode.getFile().getName().contains(".") && (readers = ImageIO.getImageReadersBySuffix(fileSuffix = resourceNode.getFile().getName().substring(resourceNode.getFile().getName().lastIndexOf(".") + 1))).hasNext()) {
                ImageReader reader = readers.next();
                logger.debug("Reading Exif metadata for {} using {}", (Object)resourceNode.getFile(), reader.getClass());
                reader.setInput(ImageIO.createImageInputStream(uri.toURL().openStream()));
                IIOMetadata metadata = reader.getImageMetadata(0);
                if (metadata != null) {
                    String[] names = metadata.getMetadataFormatNames();
                    for (int i = 0; i < names.length; ++i) {
                        logger.debug("Metadata for format: {}", (Object)names[i]);
                        this.decendExifTree(resourceNode, metadata.getAsTree(names[i]), new StringBuilder(), exifTagFields, currentFieldId);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Exception while reading Exif metadata", (Throwable)ex);
        }
        return exifTagFields.toArray(new ArbilField[0]);
    }

    private void decendExifTree(ArbilDataNode resourceNode, Node node, StringBuilder prefixString, List<ArbilField> exifTagFields, int currentFieldId) {
        if (prefixString.length() == 0) {
            prefixString.append("EXIF");
        } else {
            prefixString.append(".").append(node.getNodeName());
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int attributeCounter = 0; attributeCounter < namedNodeMap.getLength(); ++attributeCounter) {
                String attributeName = namedNodeMap.item(attributeCounter).getNodeName();
                String attributeValue = namedNodeMap.item(attributeCounter).getNodeValue();
                StringBuilder attributePath = new StringBuilder(prefixString).append(".").append(attributeName);
                logger.debug("Exif metadata: {}=>{} = {}", new Object[]{resourceNode, attributePath, attributeValue});
                exifTagFields.add(new ArbilField(currentFieldId++, resourceNode, attributePath.toString(), attributeValue, 0, false));
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int ub = children.getLength();
            for (int i = 0; i < ub; ++i) {
                this.decendExifTree(resourceNode, children.item(i), prefixString, exifTagFields, currentFieldId);
            }
        }
    }
}

