/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.util.ArrayList;
import java.util.List;
import nl.mpi.imdidb.IMDIRdbModel;

public class MDTable {
    private String tableName;
    private List<MDColumn> columns = new ArrayList<MDColumn>();
    private List<MDTable> tables = new ArrayList<MDTable>();

    public String getTableName() {
        return this.tableName;
    }

    public void setName(String tableName) {
        this.tableName = tableName;
    }

    public List<MDColumn> getColumns() {
        return this.columns;
    }

    public void addColumn(String columnName, String value) {
        this.columns.add(new MDColumn(columnName, value));
    }

    public void addTable(MDTable table) {
        this.tables.add(table);
    }

    public List<MDTable> getTables() {
        return this.tables;
    }

    public String toString() {
        return this.getTableName();
    }

    public static class MDColumn {
        private final String name;
        private final String value;
        private final String type;

        public MDColumn(String name, String value) {
            this.type = IMDIRdbModel.toColumnType(name);
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.getName();
        }
    }
}

