/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.handle.util.StringEncodingException;

public abstract class StreamUtil {
    public static char getNonWhitespace(Reader in) throws IOException {
        char ch;
        while ((ch = (char)in.read()) == ' ' || ch == '\n' || ch == '\r' || ch == ',' || ch == ';' || ch == '\t') {
        }
        return ch;
    }

    public static String readUndelimitedString(Reader in, char firstChar) throws IOException {
        StringBuffer sb = new StringBuffer("" + firstChar);
        char ch;
        while ((ch = (char)in.read()) != ' ' && ch != '\n' && ch != '\r' && ch != ',' && ch != ';' && ch != '\uffffffff' && ch != '=' && ch != '\t') {
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String readString(Reader in) throws StringEncodingException, IOException {
        StringBuffer results = new StringBuffer("");
        boolean gotNewline = false;
        while (true) {
            char ch;
            if ((ch = (char)in.read()) == '\uffffffff') {
                throw new StringEncodingException("Unexpected End of String");
            }
            if (ch == '\\') {
                ch = (char)in.read();
                if (ch == 'n') {
                    results.append('\n');
                    continue;
                }
                results.append(ch);
                continue;
            }
            if (ch == '\"') {
                return results.toString();
            }
            results.append(ch);
        }
    }

    public static String XencodeString(String str) {
        StringBuffer sb = new StringBuffer("\"");
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '\"' || ch == '\\') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append("\"");
        return sb.toString();
    }

    public static void writeEncodedString(Writer out, String str) throws IOException {
        int n = str.length();
        out.write(34);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '\"' || ch == '\\') {
                out.write(92);
            }
            out.write(ch);
        }
        out.write("\"");
    }

    public static void XwriteString(String str, Writer out) throws IOException {
        int n = str.length();
        out.write(34);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                out.write(92);
            }
            out.write(ch);
        }
        out.write(34);
    }
}

