/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.trust;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.X509TrustManager;
import nl.nikhef.slcshttps.gui.GraphTools;
import nl.nikhef.slcshttps.gui.TrustPopupComm;
import nl.nikhef.slcshttps.trust.CertChainChecker;
import nl.nikhef.slcshttps.trust.TrustCert;
import nl.nikhef.slcshttps.util.ConsoleTools;

public class TrustManagerImpl
implements X509TrustManager {
    private static final String COMMPROP = "nl.nikhef.slcshttps.comm";
    private static String host = null;
    private static int port = 443;
    private static Hashtable<String, TrustCert> trustCertsTable = null;
    private static String commString = null;
    private static TrustCommunicator comm = null;

    public TrustManagerImpl() {
        trustCertsTable = new Hashtable();
    }

    public TrustManagerImpl(String string) {
        this();
        TrustManagerImpl.setHostname(string);
    }

    public TrustManagerImpl(String string, int n) {
        this();
        TrustManagerImpl.setHostname(string);
        TrustManagerImpl.setPort(n);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (host == null) {
            throw new CertificateException("Hostname is not set, probably not using the HttxURLConnection");
        }
        String string2 = host + ":" + port;
        TrustCert trustCert = trustCertsTable.get(string2);
        if (trustCert != null) {
            if (trustCert.equals(x509CertificateArray[0])) {
                String[] stringArray;
                String string3;
                TrustCert.Status status = trustCert.status.copy();
                if (status.expired || trustCert.checkValidity() || trustCert.status.notYet) {
                    return;
                }
                String[] stringArray2 = trustCert.getOldErrors();
                String string4 = stringArray2 == null ? "Invalid certificate found while connecting to " + host + "." : "Certificate chain has expired since the last time we saw it.";
                boolean bl = comm.confirm(host, string4, string3 = "Do you want to accept it", stringArray = trustCert.getErrors(host), stringArray2);
                if (!bl) {
                    trustCert.status = status;
                    throw new CertificateException("Certificate chain for " + string2 + " has expired");
                }
                this.updateCert(string2, trustCert);
                return;
            }
            TrustCert trustCert2 = new TrustCert(x509CertificateArray);
            boolean bl = trustCert2.checkValidity();
            bl = trustCert2.checkChain() && bl;
            boolean bl2 = bl = trustCert2.checkHostname(host) && bl;
            if (!bl) {
                String string5;
                String[] stringArray = trustCert2.getErrors(host);
                String string6 = "Certificate chain for " + host + " has changed and is invalid.";
                boolean bl3 = comm.confirm(host, string6, string5 = "Do you want to accept the new one and replace the old", stringArray, null);
                if (!bl3) {
                    throw new CertificateException("Certificate for " + string2 + " failed validation");
                }
            }
            this.removeCert(string2, trustCert);
            this.addCert(string2, trustCert2);
            return;
        }
        trustCert = this.getOldCert(x509CertificateArray[0]);
        if (trustCert != null) {
            String[] stringArray;
            String string7;
            String[] stringArray3;
            String string8;
            boolean bl;
            TrustCert.Status status = trustCert.status.copy();
            boolean bl4 = trustCert.checkValidity();
            boolean bl5 = bl4 = trustCert.checkHostname(host) && bl4;
            if ((!trustCert.status.nameValid || trustCert.status.expired && !status.expired) && !(bl = comm.confirm(host, string8 = (stringArray3 = trustCert.getOldErrors()) == null ? "Invalid certificate found while connecting to " + host + "." : "Certificate chain is known but has new problems.", string7 = "Do you want to accept it", stringArray = trustCert.getErrors(host), stringArray3))) {
                trustCert.status = status;
                throw new CertificateException("Known invalid certificate not accepted for " + string2);
            }
            this.addCert(string2, trustCert);
            return;
        }
        TrustCert trustCert3 = new TrustCert(x509CertificateArray);
        boolean bl = trustCert3.checkValidity();
        bl = trustCert3.checkHostname(host) && bl;
        boolean bl6 = bl = trustCert3.checkChain() && bl;
        if (!bl) {
            String string9;
            String[] stringArray = trustCert3.getErrors(host);
            String string10 = "Invalid certificate found while connecting to " + host + ".";
            boolean bl7 = comm.confirm(host, string10, string9 = "Do you want to accept it", stringArray, null);
            if (!bl7) {
                throw new CertificateException("Unknown invalid certificate not accepted for " + string2);
            }
        }
        this.addCert(string2, trustCert3);
    }

    private void addCert(String string, TrustCert trustCert) {
        trustCert.addAlias(string);
        trustCertsTable.put(string, trustCert);
    }

    private void updateCert(String string, TrustCert trustCert) {
        trustCert.removeAlias(string);
        trustCert.addAlias(string);
    }

    private void removeCert(String string, TrustCert trustCert) {
        trustCert.removeAlias(string);
        trustCertsTable.remove(string);
    }

    private TrustCert getOldCert(X509Certificate x509Certificate) {
        TrustCert trustCert = null;
        boolean bl = false;
        Enumeration<String> enumeration = trustCertsTable.keys();
        while (enumeration.hasMoreElements()) {
            trustCert = trustCertsTable.get(enumeration.nextElement());
            if (!trustCert.equals(x509Certificate)) continue;
            bl = true;
            break;
        }
        return bl ? trustCert : null;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    public X509Certificate[] getAcceptedIssuers() {
        return CertChainChecker.getAcceptedIssuers();
    }

    public static void setHostname(String string) {
        host = string;
    }

    public static void setPort(int n) {
        port = n;
    }

    public static String setCommunicator(String string) {
        commString = !GraphTools.isGraphic() ? "stdio" : (string == null ? "stdio" : string.toLowerCase());
        if ("popup".equals(commString)) {
            comm = new TrustPopupComm();
            return commString;
        }
        if ("stdio".equals(commString)) {
            comm = new StdioComm();
            return commString;
        }
        comm = new StdioComm();
        return commString;
    }

    public static String getCommunicator() {
        return commString;
    }

    static {
        String string = System.getProperty(COMMPROP);
        TrustManagerImpl.setCommunicator(string);
    }

    static class StdioComm
    implements TrustCommunicator {
        StdioComm() {
        }

        public boolean confirm(String string, String string2, String string3, String[] stringArray, String[] stringArray2) {
            int n;
            System.err.println("SECURITY PROBLEM WHILE CONNECTING TO " + string + "!\n " + string2);
            if (stringArray2 != null) {
                System.err.println("You accepted this chain before for the following hosts/errors:");
                for (n = 0; n < stringArray2.length; ++n) {
                    System.err.println(" * " + stringArray2[n]);
                }
            }
            System.err.println("It has the following problem(s):");
            for (n = 0; n < stringArray.length; ++n) {
                System.err.println(" * " + stringArray[n]);
            }
            try {
                return ConsoleTools.getConfirm(string3);
            }
            catch (IOException iOException) {
                System.err.println("Caught exception: " + iOException.getMessage());
                System.err.println("Not confirming validation");
                return false;
            }
        }
    }

    public static interface TrustCommunicator {
        public boolean confirm(String var1, String var2, String var3, String[] var4, String[] var5);
    }
}

