/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.metadata.api.MetadataElementException;
import nl.mpi.metadata.api.events.MetadataElementListener;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.type.ContainedMetadataElementType;
import nl.mpi.metadata.api.type.MetadataElementType;
import nl.mpi.metadata.cmdi.api.model.CMDIContainerMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIMetadataElementImpl;
import nl.mpi.metadata.cmdi.api.model.impl.DefaultDisplayValueStrategy;
import nl.mpi.metadata.cmdi.api.model.impl.DisplayValueStrategy;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileElement;
import nl.mpi.metadata.cmdi.api.type.ComponentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMDIContainerMetadataElementImpl
extends CMDIMetadataElementImpl
implements CMDIContainerMetadataElement {
    private static final Logger logger = LoggerFactory.getLogger(CMDIContainerMetadataElementImpl.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(^(([^(/|\\[]*):)?([^(/|\\[]+))(\\[(\\d+)\\])?(/(.*))?$");
    private static final int PATH_PATTERN_CHILD_PATH_GROUP = 8;
    private static final int PATH_PATTERN_ELEMENT_NAME_GROUP = 4;
    private static final int PATH_PATTERN_ELEMENT_INDEX_GROUP = 6;
    private final ComponentType type;
    private final List<CMDIMetadataElement> children;
    private final Map<String, List<CMDIMetadataElement>> childrenTypeMap;

    public CMDIContainerMetadataElementImpl(ComponentType type) {
        this.type = type;
        this.children = Collections.synchronizedList(new ArrayList());
        this.childrenTypeMap = new HashMap<String, List<CMDIMetadataElement>>();
    }

    @Override
    public synchronized boolean addChildElement(CMDIMetadataElement element) throws MetadataElementException {
        if (!this.children.contains(element)) {
            this.addToChildren(element);
            this.addToChildrenTypeMap(element);
            return true;
        }
        return false;
    }

    private synchronized void addToChildren(CMDIMetadataElement element) throws MetadataElementException {
        CMDIMetadataElement insertBeforeElement = this.getInsertBeforeElement(element);
        if (insertBeforeElement == null) {
            if (!this.children.add(element)) {
                throw new MetadataElementException((MetadataElement)this, String.format("Failed to add child lement %1$s", element));
            }
        } else {
            int index = this.children.indexOf(insertBeforeElement);
            this.children.add(index, element);
        }
    }

    private CMDIMetadataElement getInsertBeforeElement(CMDIMetadataElement element) {
        CMDIProfileElement elementType = element.getType();
        List<MetadataElementType> parentTypeChildren = elementType.getParent().getContainableTypes();
        for (int childTypeIndex = parentTypeChildren.indexOf(elementType) + 1; childTypeIndex < parentTypeChildren.size(); ++childTypeIndex) {
            MetadataElementType insertBeforeType = parentTypeChildren.get(childTypeIndex);
            String typeName = insertBeforeType.getName();
            List<CMDIMetadataElement> insertBeforeTypeElements = this.childrenTypeMap.get(typeName);
            if (insertBeforeTypeElements == null || insertBeforeTypeElements.size() <= 0) continue;
            return insertBeforeTypeElements.get(0);
        }
        return null;
    }

    private synchronized void addToChildrenTypeMap(CMDIMetadataElement element) throws MetadataElementException {
        String typeName = element.getType().getName();
        List<CMDIMetadataElement> elements = this.childrenTypeMap.get(typeName);
        if (elements == null) {
            elements = new ArrayList<CMDIMetadataElement>();
            this.childrenTypeMap.put(typeName, elements);
        }
        if (!elements.add(element)) {
            throw new MetadataElementException((MetadataElement)this, String.format("Failed to add child element to childrenTypeMap %1$s", element));
        }
    }

    @Override
    public synchronized boolean removeChildElement(CMDIMetadataElement element) throws MetadataElementException {
        if (this.children.remove(element)) {
            this.setDirty(true);
            List<CMDIMetadataElement> elements = this.childrenTypeMap.get(element.getType().getName());
            if (elements == null) {
                throw new AssertionError((Object)"No list in children map for removed child element");
            }
            if (!elements.remove(element)) {
                throw new MetadataElementException((MetadataElement)this, String.format("Child %1$s was removed but could not be deleted from map", element));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddInstanceOfType(ContainedMetadataElementType type) {
        if (type instanceof CMDIProfileElement && this.getType().getContainableTypes().contains(type)) {
            int maxOccurences = type.getMaxOccurences();
            return maxOccurences < 0 || maxOccurences > this.getChildrenCount((CMDIProfileElement)type);
        }
        return false;
    }

    @Override
    public synchronized CMDIMetadataElement getChildElement(CMDIProfileElement type, int index) throws IndexOutOfBoundsException {
        List<CMDIMetadataElement> elements = this.childrenTypeMap.get(type.getName());
        if (elements == null) {
            return null;
        }
        return elements.get(index);
    }

    @Override
    public CMDIMetadataElement getChildElement(String path) throws IllegalArgumentException {
        String elementName;
        if (path.startsWith(this.getMetadataDocument().getPathString())) {
            String rootChildPath = path.substring(this.getMetadataDocument().getPathString().length() + 1);
            return (CMDIMetadataElement)this.getMetadataDocument().getChildElement(rootChildPath);
        }
        Matcher pathMatcher = PATH_PATTERN.matcher(path);
        if (pathMatcher.find() && (elementName = pathMatcher.group(4)) != null && elementName.length() > 0) {
            String elementIndexString = pathMatcher.group(6);
            String childPath = pathMatcher.group(8);
            return this.getChildElement(elementName, elementIndexString, childPath);
        }
        throw new IllegalArgumentException(String.format("Path does not match accepted pattern: %1$s", path));
    }

    private synchronized CMDIMetadataElement getChildElement(String elementName, String elementIndexString, String childPath) throws NumberFormatException {
        block5: {
            List<CMDIMetadataElement> elements = this.childrenTypeMap.get(elementName);
            if (elements != null) {
                int elementIndex = elementIndexString == null || elementIndexString.length() == 0 ? 0 : Integer.valueOf(elementIndexString) - 1;
                try {
                    CMDIMetadataElement childElement = elements.get(elementIndex);
                    if (childPath != null && childPath.length() > 0) {
                        if (childElement instanceof CMDIContainerMetadataElement) {
                            return (CMDIMetadataElement)((CMDIContainerMetadataElement)childElement).getChildElement(childPath);
                        }
                        break block5;
                    }
                    return childElement;
                }
                catch (IndexOutOfBoundsException ioobEx) {
                    logger.warn("Requested node has index >= collection size: {}[{}]. Remaining child path:", new Object[]{elementName, elementIndexString, childPath});
                    logger.debug("IndexOutOfBoundsException details:", (Throwable)ioobEx);
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public synchronized List<MetadataElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public synchronized List<MetadataElement> getChildren(ContainedMetadataElementType childType) {
        if (this.childrenTypeMap.containsKey(childType.getName())) {
            return Collections.unmodifiableList(this.childrenTypeMap.get(childType.getName()));
        }
        return Collections.emptyList();
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public synchronized int getChildrenCount(CMDIProfileElement childType) {
        if (this.childrenTypeMap.containsKey(childType.getName())) {
            return this.childrenTypeMap.get(childType.getName()).size();
        }
        return 0;
    }

    @Override
    public void addMetadataElementListener(MetadataElementListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeMetadataElementListener(MetadataElementListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(new DefaultDisplayValueStrategy());
    }

    @Override
    public String getDisplayValue(DisplayValueStrategy displayStrategy) {
        return displayStrategy.getDisplayValue(this.getChildren(), this);
    }

    @Override
    public ComponentType getType() {
        return this.type;
    }
}

