/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleManager
implements Serializable {
    private Mode unnamedMode;
    private HashMap<StructuredQName, Mode> modes;
    private Mode omniMode = null;
    private int recoveryPolicy;

    public RuleManager() {
        this.resetHandlers();
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        this.unnamedMode.setRecoveryPolicy(policy);
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public Collection<Mode> getAllNamedModes() {
        return this.modes.values();
    }

    public void resetHandlers() {
        this.unnamedMode = new Mode(-1, Mode.UNNAMED_MODE_NAME);
        this.unnamedMode.setRecoveryPolicy(this.recoveryPolicy);
        this.modes = new HashMap(5);
    }

    public Mode getUnnamedMode() {
        return this.unnamedMode;
    }

    public Mode getMode(StructuredQName modeName, boolean createIfAbsent) {
        if (modeName == null || modeName.equals(Mode.UNNAMED_MODE_NAME)) {
            return this.unnamedMode;
        }
        if (modeName.equals(Mode.ALL_MODES)) {
            if (this.omniMode == null) {
                this.omniMode = new Mode(-3, modeName);
                this.omniMode.setRecoveryPolicy(this.recoveryPolicy);
            }
            return this.omniMode;
        }
        Mode m = this.modes.get(modeName);
        if (m == null && createIfAbsent) {
            m = new Mode(this.omniMode, modeName);
            m.setRecoveryPolicy(this.recoveryPolicy);
            this.modes.put(modeName, m);
        }
        return m;
    }

    public void setTemplateRule(Pattern pattern, Template eh, Mode mode, StylesheetModule module, double priority) {
        if (pattern instanceof UnionPattern) {
            UnionPattern up = (UnionPattern)pattern;
            Pattern p1 = up.getLHS();
            Pattern p2 = up.getRHS();
            this.setTemplateRule(p1, eh, mode, module, priority);
            this.setTemplateRule(p2, eh, mode, module, priority);
            return;
        }
        if (pattern instanceof ItemTypePattern && pattern.getItemType() instanceof CombinedNodeTest && ((CombinedNodeTest)pattern.getItemType()).getOperator() == 1) {
            CombinedNodeTest cnt = (CombinedNodeTest)pattern.getItemType();
            NodeTest[] nt = cnt.getComponentNodeTests();
            this.setTemplateRule(new ItemTypePattern(nt[0]), eh, mode, module, priority);
            this.setTemplateRule(new ItemTypePattern(nt[1]), eh, mode, module, priority);
            return;
        }
        if (Double.isNaN(priority)) {
            priority = pattern.getDefaultPriority();
        }
        mode.addRule(pattern, eh, module, priority, true);
        if (mode == this.omniMode) {
            this.unnamedMode.addRule(pattern, eh, module, priority, false);
            for (Mode m : this.modes.values()) {
                m.addRule(pattern, eh, module, priority, false);
            }
        }
    }

    public Rule getTemplateRule(Item item, Mode mode, int min, int max, XPathContext c) throws XPathException {
        if (mode == null) {
            mode = this.unnamedMode;
        }
        return mode.getRule(item, min, max, c);
    }

    public Rule getNextMatchHandler(Item node, Mode mode, Rule currentRule, XPathContext c) throws XPathException {
        if (mode == null) {
            mode = this.unnamedMode;
        }
        return mode.getNextMatchRule(node, currentRule, c);
    }

    public void computeRankings() throws XPathException {
        this.unnamedMode.computeRankings();
        for (Mode mode : this.modes.values()) {
            mode.computeRankings();
        }
    }

    public void invertStreamableTemplates(Optimizer opt) throws XPathException {
        this.unnamedMode.invertStreamableTemplates(opt);
        for (Mode mode : this.modes.values()) {
            mode.invertStreamableTemplates(opt);
        }
    }

    public void explainTemplateRules(ExpressionPresenter presenter) {
        presenter.startElement("templateRules");
        this.unnamedMode.explainTemplateRules(presenter);
        for (Mode mode : this.modes.values()) {
            int s = presenter.startElement("mode");
            if (!mode.isDefaultMode()) {
                presenter.emitAttribute("name", mode.getModeName().getDisplayName());
            }
            presenter.emitAttribute("streamable", Boolean.toString(mode.isStreamable()));
            mode.explainTemplateRules(presenter);
            int e = presenter.endElement();
            if (s == e) continue;
            throw new IllegalStateException("tree unbalanced");
        }
        presenter.endElement();
    }
}

