/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WebstartHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationVersionManager {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationVersionManager.class);
    private static MessageDialogHandler messageDialogHandler;
    private static SessionStorage sessionStorage;
    private static final ResourceBundle services;
    private ApplicationVersion applicationVersion;
    private final WebstartHelper webstartHelper = new WebstartHelper();
    private final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)");

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public ApplicationVersionManager(ApplicationVersion appVersion) {
        this.applicationVersion = appVersion;
    }

    public ApplicationVersion getApplicationVersion() {
        return this.applicationVersion;
    }

    public boolean forceUpdateCheck() {
        File cachePath = sessionStorage.getSaveLocation(this.applicationVersion.currentVersionFile);
        if (cachePath.delete()) {
            logger.debug("Dropped old version file");
        } else {
            messageDialogHandler.addMessageDialogToQueue(services.getString("COULD NOT WRITE TO STORAGE DIRECTORY. UPDATE CHECK FAILED!"), services.getString("ERROR"));
        }
        return this.checkForUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLatestVersion() {
        BufferedReader bufferedReader = null;
        try {
            int daysTillExpire = 1;
            File cachePath = sessionStorage.updateCache(this.applicationVersion.currentVersionFile, daysTillExpire, false);
            bufferedReader = new BufferedReader(new FileReader(cachePath));
            String serverVersionString = bufferedReader.readLine();
            logger.debug("currentRevision: {}", (Object)this.applicationVersion.currentRevision);
            logger.debug("serverVersionString: {}", (Object)serverVersionString);
            if (serverVersionString == null) {
                boolean bl = true;
                return bl;
            }
            Matcher matcher = this.VERSION_PATTERN.matcher(serverVersionString);
            if (!matcher.matches()) {
                boolean ex = true;
                return ex;
            }
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int revision = Integer.parseInt(matcher.group(3));
            int currentMajor = Integer.parseInt(this.applicationVersion.currentMajor);
            int currentMinor = Integer.parseInt(this.applicationVersion.currentMinor);
            int currentRevision = Integer.parseInt(this.applicationVersion.currentRevision);
            boolean bl = ApplicationVersionManager.compareVersions(currentMajor, currentMinor, currentRevision, major, minor, revision);
            return bl;
        }
        catch (IOException ex) {
            logger.warn("Could not download current version information");
            logger.info("Failed to download current version information", (Throwable)ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    logger.warn("Could not close stream to version information");
                    logger.info("Failed to close stream to version information", (Throwable)ex);
                }
            }
        }
        return true;
    }

    public static boolean compareVersions(int currentMajor, int currentMinor, int currentRevision, int major, int minor, int revision) {
        return currentMajor > major || currentMajor == major && currentMinor > minor || currentMajor == major && currentMinor == minor && currentRevision >= revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdate(String updateUrl) {
        BufferedReader errorStreamReader = null;
        try {
            String line;
            Process launchedProcess = Runtime.getRuntime().exec(new String[]{"javaws", "-import", updateUrl});
            errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
            while ((line = errorStreamReader.readLine()) != null) {
                logger.debug("Launched process error stream: \"" + line + "\"");
            }
            boolean bl = 0 == launchedProcess.waitFor();
            return bl;
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
        finally {
            if (errorStreamReader != null) {
                try {
                    errorStreamReader.close();
                }
                catch (IOException ioe) {
                    BugCatcherManager.getBugCatcher().logError(ioe);
                }
            }
        }
        return false;
    }

    private void restartApplication(String updateUrl) {
        try {
            Process restartProcess = Runtime.getRuntime().exec(new String[]{"javaws", updateUrl});
            if (0 == restartProcess.waitFor()) {
                System.exit(0);
            } else {
                messageDialogHandler.addMessageDialogToQueue(services.getString("THERE WAS AN ERROR RESTARTING THE APPLICATION.THE UPDATE WILL TAKE EFFECT NEXT TIME THE APPLICATION IS RESTARTED."), null);
            }
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
    }

    public boolean checkForUpdate() {
        if (!this.isLatestVersion()) {
            if (this.webstartHelper.isWebStart()) {
                this.checkForAndUpdateViaJavaws();
            } else {
                new Thread("checkForUpdate"){

                    public void run() {
                        messageDialogHandler.addMessageDialogToQueue(services.getString("THERE IS A NEW VERSION AVAILABLE.PLEASE GO TO THE WEBSITE AND UPDATE VIA THE DOWNLOAD LINK."), null);
                    }
                }.start();
            }
            return true;
        }
        return false;
    }

    private void checkForAndUpdateViaJavaws() {
        new Thread("checkForAndUpdateViaJavaws"){

            public void run() {
                String updateUrl = ApplicationVersionManager.this.webstartHelper.getWebstartUrl();
                if (updateUrl != null && !ApplicationVersionManager.this.isLatestVersion()) {
                    switch (messageDialogHandler.showDialogBox(services.getString("There is a new version available"), ((ApplicationVersionManager)ApplicationVersionManager.this).applicationVersion.applicationTitle, 1, -1)) {
                        case 1: {
                            break;
                        }
                        case 0: {
                            if (ApplicationVersionManager.this.doUpdate(updateUrl)) {
                                ApplicationVersionManager.this.restartApplication(updateUrl);
                                break;
                            }
                            messageDialogHandler.addMessageDialogToQueue(services.getString("THERE WAS AN ERROR UPDATING THE APPLICATION.PLEASE GO TO THE WEBSITE AND UPDATE VIA THE DOWNLOAD LINK."), null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
        }.start();
    }

    static {
        services = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Services");
    }
}

