/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.imdidb.IMDIQueryToSQL;
import nl.mpi.util.DBConnection;

public class MakeIMDIQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("MakeIMDIQuery: No arguments");
            return;
        }
        String user = null;
        String passwd = null;
        String query = null;
        String dbname = args[0];
        for (int ai = 1; ai < args.length; ++ai) {
            if (args[ai].startsWith("-user")) {
                user = args[ai + 1];
                ++ai;
                continue;
            }
            if (args[ai].startsWith("-passwd")) {
                passwd = args[ai + 1];
                ++ai;
                continue;
            }
            if (!args[ai].startsWith("-q")) continue;
            query = args[ai + 1];
            ++ai;
        }
        System.out.println("MakeIMDIQuery: dbname=" + dbname + " ,user=" + user + " ,q=" + query);
        IMDIQueryToSQL q2sql = new IMDIQueryToSQL();
        String sql = null;
        try {
            sql = q2sql.IMDIqueryToSQL(query);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        System.out.println("MakeIMDIQuery: SQL statement=" + sql);
        Statement statement = null;
        ResultSet rs = null;
        try {
            DBConnection db = new DBConnection(dbname, user, passwd, "ArchiveCrawler:main()");
            System.out.println("MakeIMDIQuery: created connection to: " + dbname);
            statement = db.getConnection().createStatement();
            rs = statement.executeQuery(sql);
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                System.out.print(NodeIdUtils.TONODEID((Integer)rs.getObject(1)) + " ");
                for (int i = 1; i < columns; ++i) {
                    System.out.print(rs.getObject(i + 1) + " ");
                }
                System.out.println("");
            }
        }
        catch (RuntimeException re) {
            System.out.println("RuntimeException: " + re);
            re.printStackTrace();
        }
        catch (SQLException sqle) {
            System.out.println("SQLException: " + sqle);
            sqle.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    System.out.println("Close resultset failed.");
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    System.out.println("Close statement failed.");
                }
            }
        }
    }
}

