/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.identifierresolver;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import nl.mpi.metadata.api.model.MetadataDocument;
import nl.mpi.metadata.identifierresolver.IdentifierResolutionException;
import nl.mpi.metadata.identifierresolver.IdentifierResolver;

public class URLResolver
implements IdentifierResolver {
    @Override
    public boolean canResolve(MetadataDocument document, URI identifier) {
        String scheme = identifier.getScheme();
        if (identifier.isAbsolute()) {
            return scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("file");
        }
        if (document != null && document.getFileLocation().isAbsolute()) {
            try {
                document.getFileLocation().toURL();
                return true;
            }
            catch (MalformedURLException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public URL resolveIdentifier(MetadataDocument document, URI identifier) {
        try {
            return document.getFileLocation().resolve(identifier).toURL();
        }
        catch (MalformedURLException ex) {
            throw new IdentifierResolutionException(ex);
        }
    }
}

