/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.util.ArrayList;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.relationlines.RelationRecord;
import nl.mpi.kinnate.svg.relationlines.RelationRecordTable;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationSvg {
    private MessageDialogHandler dialogHandler;

    public RelationSvg(MessageDialogHandler dialogHandler) {
        this.dialogHandler = dialogHandler;
    }

    private void addUseNode(SVGDocument doc, String svgNameSpace, Element targetGroup, String targetDefId) {
        String useNodeId = targetDefId + "use";
        Element useNodeOld = doc.getElementById(useNodeId);
        if (useNodeOld != null) {
            useNodeOld.getParentNode().removeChild(useNodeOld);
        }
        Element useNode = doc.createElementNS(svgNameSpace, "use");
        useNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + targetDefId);
        useNode.setAttribute("id", useNodeId);
        targetGroup.appendChild(useNode);
    }

    private void updateLabelNode(SVGDocument doc, String svgNameSpace, String lineIdString, String targetRelationId) {
        String labelNodeId = targetRelationId + "label";
        Element useNodeOld = doc.getElementById(labelNodeId);
        if (useNodeOld != null) {
            Node textParentNode = useNodeOld.getParentNode();
            String labelText = useNodeOld.getTextContent();
            useNodeOld.getParentNode().removeChild(useNodeOld);
            Element textPath = doc.createElementNS(svgNameSpace, "textPath");
            textPath.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + lineIdString);
            textPath.setAttribute("startOffset", "50%");
            textPath.setAttribute("id", labelNodeId);
            Text textNode = doc.createTextNode(labelText);
            textPath.appendChild(textNode);
            textParentNode.appendChild(textPath);
        }
    }

    public void createRelationElements(GraphPanel graphPanel, RelationRecordTable relationRecords, Element relationGroupNode) throws OldFormatException {
        relationRecords.adjustLines();
        for (RelationRecord relationRecord : relationRecords.getAllRecords()) {
            Element groupNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "g");
            groupNode.setAttribute("id", relationRecord.idString);
            Element defsNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "defs");
            boolean addedRelationLine = false;
            Element linkLine = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "path");
            linkLine.setAttribute("d", relationRecord.getPathPointsString());
            if (relationRecord.lineDash > 0) {
                linkLine.setAttribute("stroke-dasharray", Integer.toString(relationRecord.lineDash));
                linkLine.setAttribute("stroke-dashoffset", "0");
            }
            linkLine.setAttribute("fill", "none");
            if (relationRecord.lineColour != null) {
                linkLine.setAttribute("stroke", relationRecord.lineColour);
            } else {
                linkLine.setAttribute("stroke", "grey");
            }
            linkLine.setAttribute("stroke-width", Integer.toString(relationRecord.lineWidth));
            linkLine.setAttribute("id", relationRecord.lineIdString);
            defsNode.appendChild(linkLine);
            addedRelationLine = true;
            groupNode.appendChild(defsNode);
            if (addedRelationLine) {
                this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, groupNode, relationRecord.lineIdString);
                if (relationRecord.lineLabel != null) {
                    Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
                    labelText.setAttribute("text-anchor", "middle");
                    if (relationRecord.lineColour != null) {
                        labelText.setAttribute("fill", relationRecord.lineColour);
                    } else {
                        labelText.setAttribute("fill", "blue");
                    }
                    labelText.setAttribute("stroke-width", "0");
                    labelText.setAttribute("font-size", "14");
                    groupNode.appendChild(labelText);
                }
            }
            relationGroupNode.appendChild(groupNode);
        }
    }

    public void updateRelationLines(GraphPanel graphPanel, RelationRecordTable relationRecords, ArrayList<UniqueIdentifier> draggedNodeIds, int hSpacing, int vSpacing) throws OldFormatException {
        relationRecords.adjustLines();
        Element relationGroup = graphPanel.doc.getElementById("RelationGroup");
        for (Node currentChild = relationGroup.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            RelationRecord relationRecord;
            Node idAttrubite;
            String lineElementId;
            Element relationLineElement;
            if (!"g".equals(currentChild.getLocalName()) || (relationLineElement = graphPanel.doc.getElementById(lineElementId = (idAttrubite = currentChild.getAttributes().getNamedItem("id")).getNodeValue() + "Line")) == null) continue;
            if ("polyline".equals(relationLineElement.getLocalName())) {
                relationRecord = relationRecords.getRecord(lineElementId);
                relationLineElement.setAttribute("points", relationRecord.getPathPointsString());
            }
            if ("path".equals(relationLineElement.getLocalName())) {
                relationRecord = relationRecords.getRecord(lineElementId);
                relationLineElement.setAttribute("d", relationRecord.getPathPointsString());
            }
            this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, (Element)currentChild, lineElementId);
            this.updateLabelNode(graphPanel.doc, graphPanel.svgNameSpace, lineElementId, idAttrubite.getNodeValue());
        }
    }
}

