/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.awt.Point;
import java.util.HashSet;
import nl.mpi.kinnate.svg.relationlines.LineRecord;

public class LineLookUpTable {
    HashSet<LineRecord> lineRecords = new HashSet();
    boolean excludeFirstLastSegments = true;

    protected LineLookUpTable() {
    }

    public void getIntersectsEntity() {
    }

    public void getOverlapsOtherLine() {
    }

    private boolean intersects(Point[] horizontalLine, Point[] verticalLine) {
        boolean startsBefore = horizontalLine[0].x <= verticalLine[0].x;
        boolean endsBefore = horizontalLine[1].x <= verticalLine[0].x;
        boolean startsAbove = verticalLine[0].y <= horizontalLine[0].y;
        boolean endsAbove = verticalLine[1].y <= horizontalLine[0].y;
        return startsBefore != endsBefore && startsAbove != endsAbove;
    }

    private boolean overlaps(Point[] lineA, Point[] lineB) {
        boolean zeroLength;
        boolean verticalMatch = lineA[0].x == lineB[0].x && lineA[0].x == lineB[1].x && lineA[0].x == lineA[1].x;
        boolean horizontalMatch = lineA[0].y == lineB[0].y && lineA[0].y == lineB[1].y && lineA[0].y == lineA[1].y;
        int startA = lineA[0].x;
        int startB = lineB[0].x;
        int endA = lineA[1].x;
        int endB = lineB[1].x;
        if (verticalMatch) {
            startA = lineA[0].y;
            startB = lineB[0].y;
            endA = lineA[1].y;
            endB = lineB[1].y;
        }
        boolean bl = zeroLength = startA == endA || startB == endB;
        if (zeroLength) {
            return false;
        }
        if (horizontalMatch || verticalMatch) {
            if (startA <= startB && startA >= endB) {
                return true;
            }
            if (startA >= startB && startA <= endB) {
                return true;
            }
            if (startB <= startA && startB >= endA) {
                return true;
            }
            if (startB >= startA && startB <= endA) {
                return true;
            }
        }
        return false;
    }

    public void separateOverlappingLines() {
        int offset = 0;
        if (this.excludeFirstLastSegments) {
            offset = 1;
        }
        LineRecord[] lineRecordArray = this.lineRecords.toArray(new LineRecord[0]);
        for (int lineRecordCount = 0; lineRecordCount < lineRecordArray.length; ++lineRecordCount) {
            LineRecord lineRecordOuter = lineRecordArray[lineRecordCount];
            for (int currentIndexA = 0 + offset; currentIndexA <= lineRecordOuter.getLastSegment() - offset; ++currentIndexA) {
                Point[] currentSegmentA = lineRecordOuter.getSegment(currentIndexA);
                for (int lineRecordInnerCount = lineRecordCount + 1; lineRecordInnerCount < lineRecordArray.length; ++lineRecordInnerCount) {
                    if (lineRecordCount == lineRecordInnerCount) continue;
                    LineRecord lineRecordInner = lineRecordArray[lineRecordInnerCount];
                    for (int currentIndexB = 0 + offset; currentIndexB <= lineRecordInner.getLastSegment() - offset; ++currentIndexB) {
                        Point[] otherHorizontalLine = lineRecordInner.getSegment(currentIndexB);
                        if (!this.overlaps(currentSegmentA, otherHorizontalLine)) continue;
                        lineRecordInner.moveAside(currentIndexB, 6);
                    }
                }
            }
        }
    }

    public void addLoops() {
        for (LineRecord lineRecordForLoops : this.lineRecords) {
            int currentHorizontal = lineRecordForLoops.getLastHorizontal();
            while (currentHorizontal > -1) {
                Point[] currentHorizontalLine = lineRecordForLoops.getSegment(currentHorizontal);
                for (LineRecord lineRecord : this.lineRecords) {
                    if (lineRecord == lineRecordForLoops) continue;
                    int currentVertical = lineRecord.getFirstVertical();
                    while (currentVertical > -1) {
                        Point[] currentVerticalLine = lineRecord.getSegment(currentVertical);
                        if (this.intersects(currentHorizontalLine, currentVerticalLine)) {
                            boolean isLeftHand = currentHorizontalLine[0].x > currentHorizontalLine[1].x;
                            lineRecordForLoops.insertLoop(currentHorizontal, currentVerticalLine[0].x, isLeftHand);
                        }
                        currentVertical = lineRecord.getNextVertical(currentVertical);
                    }
                }
                currentHorizontal = lineRecordForLoops.getPrevHorizontal(currentHorizontal);
            }
            lineRecordForLoops.sortLoops();
        }
    }

    public void addRecord(LineRecord lineRecord) {
        this.lineRecords.add(lineRecord);
    }
}

