/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineRecord {
    private String lineIdSring;
    private ArrayList<Point> pointsList;
    private ArrayList<IntersectionRecord> intersectionList = new ArrayList();

    public LineRecord(String lineIdString, ArrayList<Point> pointsList) {
        this.lineIdSring = lineIdString;
        this.pointsList = pointsList;
    }

    protected int getLastSegment() {
        return this.pointsList.size() - 2;
    }

    protected int getLastHorizontal() {
        return this.getPrevHorizontal(this.pointsList.size() - 1);
    }

    protected int getPrevHorizontal(int current) {
        return this.getPrev(current, Orientation.horizontal);
    }

    protected int getFirstHorizontal() {
        return this.getNextHorizontal(-1);
    }

    protected int getNextHorizontal(int current) {
        return this.getNext(current, Orientation.horizontal);
    }

    protected int getFirstVertical() {
        return this.getNextVertical(-1);
    }

    protected int getNextVertical(int current) {
        return this.getNext(current, Orientation.vertical);
    }

    private int getPrev(int current, Orientation orientation) {
        block4: for (int currentIndex = current - 1; currentIndex > 0; --currentIndex) {
            Point startPoint = this.pointsList.get(currentIndex);
            Point endPoint = this.pointsList.get(currentIndex + 1);
            switch (orientation) {
                case horizontal: {
                    if (startPoint.x == endPoint.x) continue block4;
                    return currentIndex;
                }
                case vertical: {
                    if (startPoint.y == endPoint.y) continue block4;
                    return currentIndex;
                }
            }
        }
        return -1;
    }

    private int getNext(int current, Orientation orientation) {
        block4: for (int currentIndex = current + 1; currentIndex < this.pointsList.size() - 1; ++currentIndex) {
            Point startPoint = this.pointsList.get(currentIndex);
            Point endPoint = this.pointsList.get(currentIndex + 1);
            switch (orientation) {
                case horizontal: {
                    if (startPoint.x == endPoint.x) continue block4;
                    return currentIndex;
                }
                case vertical: {
                    if (startPoint.y == endPoint.y) continue block4;
                    return currentIndex;
                }
            }
        }
        return -1;
    }

    protected Point[] getSegment(int segmentIndex) {
        return new Point[]{this.pointsList.get(segmentIndex), this.pointsList.get(segmentIndex + 1)};
    }

    public void moveAside(int linePart, int distance) {
        Point startPoint = this.pointsList.get(linePart);
        Point endPoint = this.pointsList.get(linePart + 1);
        if (startPoint.x == endPoint.x) {
            startPoint.setLocation(startPoint.x - distance, startPoint.y);
            endPoint.setLocation(endPoint.x - distance, endPoint.y);
        } else {
            startPoint.setLocation(startPoint.x, startPoint.y - distance);
            endPoint.setLocation(endPoint.x, endPoint.y - distance);
        }
    }

    public void sortLoops() {
        Collections.sort(this.intersectionList);
    }

    public void insertLoop(int linePart, int positionX, boolean isLeftHand) {
        Point startPoint = this.pointsList.get(linePart);
        int centerX = positionX;
        int centerY = startPoint.y;
        Point intersectionPoint = new Point(centerX, centerY);
        this.intersectionList.add(new IntersectionRecord(linePart, intersectionPoint, isLeftHand));
    }

    private boolean addCurveLoops(StringBuilder stringBuilder, int segmentIndex, int separationDistance) {
        boolean lineToRequired = false;
        Point lastPoint = null;
        for (IntersectionRecord intersectionRecord : this.intersectionList) {
            if (lastPoint != null && lastPoint.equals(intersectionRecord.intersectionPoint)) continue;
            lastPoint = intersectionRecord.intersectionPoint;
            int separationDistanceDirected = intersectionRecord.isLeftHand ? -separationDistance : separationDistance;
            if (intersectionRecord.lineSegment != segmentIndex) continue;
            if (lineToRequired) {
                stringBuilder.append("L ");
            }
            stringBuilder.append(intersectionRecord.intersectionPoint.x - separationDistanceDirected / 2);
            stringBuilder.append(",");
            stringBuilder.append(intersectionRecord.intersectionPoint.y);
            stringBuilder.append(" ");
            stringBuilder.append("s ");
            stringBuilder.append(separationDistanceDirected / 2);
            stringBuilder.append(",");
            stringBuilder.append(-separationDistance);
            stringBuilder.append(" ");
            stringBuilder.append(separationDistanceDirected);
            stringBuilder.append(",0 ");
            lineToRequired = true;
        }
        return lineToRequired;
    }

    public String getPointsAttribute() {
        int separationDistance = 8;
        StringBuilder stringBuilder = new StringBuilder();
        boolean moveRequired = true;
        boolean lineToRequired = true;
        for (int segmentIndex = 0; segmentIndex < this.pointsList.size(); ++segmentIndex) {
            Point currentPoint = this.pointsList.get(segmentIndex);
            if (moveRequired) {
                moveRequired = false;
                stringBuilder.append("M ");
            } else if (lineToRequired) {
                lineToRequired = false;
                stringBuilder.append("L ");
            }
            stringBuilder.append(currentPoint.x);
            stringBuilder.append(",");
            stringBuilder.append(currentPoint.y);
            stringBuilder.append(" ");
            if (lineToRequired) {
                lineToRequired = false;
                stringBuilder.append("L ");
            }
            lineToRequired = this.addCurveLoops(stringBuilder, segmentIndex, separationDistance);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineRecord other = (LineRecord)obj;
        return !(this.lineIdSring == null ? other.lineIdSring != null : !this.lineIdSring.equals(other.lineIdSring));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.lineIdSring != null ? this.lineIdSring.hashCode() : 0);
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntersectionRecord
    implements Comparable<IntersectionRecord> {
        int lineSegment;
        Point intersectionPoint;
        boolean isLeftHand;

        public IntersectionRecord(int lineSegment, Point intersectionPoint, boolean isLeftHand) {
            this.lineSegment = lineSegment;
            this.intersectionPoint = intersectionPoint;
            this.isLeftHand = isLeftHand;
        }

        @Override
        public int compareTo(IntersectionRecord o) {
            if (this.lineSegment != o.lineSegment) {
                return this.lineSegment - o.lineSegment;
            }
            if (!this.isLeftHand) {
                return this.intersectionPoint.x - o.intersectionPoint.x;
            }
            return o.intersectionPoint.x - this.intersectionPoint.x;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Orientation {
        horizontal,
        vertical;

    }
}

