/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.relationlines.LineLookUpTable;
import nl.mpi.kinnate.svg.relationlines.LineRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationRecord {
    public String idString;
    public String lineIdString;
    public GraphPanel graphPanel;
    public EntityData leftEntity;
    public EntityData rightEntity;
    public DataTypes.RelationType directedRelation;
    public int lineWidth;
    public int lineDash;
    public RelationTypeDefinition.CurveLineOrientation curveLineOrientation;
    public String lineColour;
    public String lineLabel;
    public int hSpacing;
    public int vSpacing;
    public int relationLineIndex;
    public LineRecord lineRecord;
    private String curveLinePoints = null;

    public RelationRecord(String lineIdString, DataTypes.RelationType relationType, float vSpacing, float egoX, float egoY, float alterX, float alterY, float[] averageParentPassed) throws OldFormatException {
        this.lineRecord = this.setPolylinePointsAttribute(lineIdString, relationType, vSpacing, egoX, egoY, alterX, alterY, averageParentPassed);
    }

    public RelationRecord(RelationTypeDefinition.CurveLineOrientation curveLineOrientation, float hSpacing, float vSpacing, float egoX, float egoY, float alterX, float alterY) {
        this.curveLinePoints = this.setPathPointsAttribute(curveLineOrientation, hSpacing, vSpacing, egoX, egoY, alterX, alterY);
    }

    protected RelationRecord(GraphPanel graphPanel, int relationLineIndex, EntityData leftEntity, EntityData rightEntity, DataTypes.RelationType directedRelation, int lineWidth, int lineDash, RelationTypeDefinition.CurveLineOrientation curveLineOrientation, String lineColour, String lineLabel, int hSpacing, int vSpacing) throws OldFormatException {
        this.graphPanel = graphPanel;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
        this.directedRelation = directedRelation;
        this.lineWidth = lineWidth;
        this.lineDash = lineDash;
        this.curveLineOrientation = curveLineOrientation;
        this.lineColour = lineColour;
        this.lineLabel = lineLabel;
        this.hSpacing = hSpacing;
        this.vSpacing = vSpacing;
        this.relationLineIndex = relationLineIndex;
        this.idString = "relation" + relationLineIndex;
        this.lineIdString = "relation" + relationLineIndex + "Line";
    }

    public boolean pertainsToEntity(ArrayList<UniqueIdentifier> selectedIdentifiers) {
        return selectedIdentifiers.contains(this.leftEntity.getUniqueIdentifier()) || selectedIdentifiers.contains(this.rightEntity.getUniqueIdentifier());
    }

    public String getPathPointsString() {
        String returnValue = this.curveLinePoints != null ? this.curveLinePoints : this.lineRecord.getPointsAttribute();
        return returnValue;
    }

    public float[] getAverageParentLocation(HashSet<UniqueIdentifier> parentIdSet) {
        Float maxY = null;
        float averageX = 0.0f;
        int parentCount = 0;
        if (parentIdSet != null) {
            for (UniqueIdentifier parentIdentifier : parentIdSet) {
                float[] parentLoc = this.graphPanel.entitySvg.getEntityLocation(parentIdentifier);
                maxY = maxY == null ? Float.valueOf(parentLoc[1]) : Float.valueOf(maxY.floatValue() >= parentLoc[1] ? maxY.floatValue() : parentLoc[1]);
                averageX += parentLoc[0];
                ++parentCount;
            }
        }
        averageX /= (float)parentCount;
        if (maxY == null) {
            return null;
        }
        return new float[]{averageX, maxY.floatValue()};
    }

    public float[] getAverageParentLocation(EntityData entityData) {
        HashSet<UniqueIdentifier> identifierSet = new HashSet<UniqueIdentifier>();
        for (EntityRelation entityRelation : entityData.getAllRelations()) {
            if (entityRelation.getAlterNode() == null || !entityRelation.getAlterNode().isVisible || entityRelation.getRelationType() != DataTypes.RelationType.ancestor) continue;
            identifierSet.add(entityRelation.alterUniqueIdentifier);
        }
        if (identifierSet.size() < 2) {
            return null;
        }
        return this.getAverageParentLocation(identifierSet);
    }

    public void updatePathPoints(LineLookUpTable lineLookUpTable) throws OldFormatException {
        float[] egoSymbolPoint = this.graphPanel.entitySvg.getEntityLocation(this.leftEntity.getUniqueIdentifier());
        float[] alterSymbolPoint = this.graphPanel.entitySvg.getEntityLocation(this.rightEntity.getUniqueIdentifier());
        float[] parentPoint = this.getAverageParentLocation(this.leftEntity);
        float fromX = egoSymbolPoint[0];
        float fromY = egoSymbolPoint[1];
        float toX = alterSymbolPoint[0];
        float toY = alterSymbolPoint[1];
        if (!DataTypes.isSanguinLine(this.directedRelation)) {
            this.curveLinePoints = this.setPathPointsAttribute(this.curveLineOrientation, this.hSpacing, this.vSpacing, fromX, fromY, toX, toY);
        } else {
            this.lineRecord = this.setPolylinePointsAttribute(this.lineIdString, this.directedRelation, this.vSpacing, fromX, fromY, toX, toY, parentPoint);
            lineLookUpTable.addRecord(this.lineRecord);
        }
    }

    private LineRecord setPolylinePointsAttribute(String lineIdString, DataTypes.RelationType relationType, float vSpacing, float egoX, float egoY, float alterX, float alterY, float[] averageParentPassed) throws OldFormatException {
        float alterYmid;
        float egoYmid;
        ArrayList<Point> initialPointsList = new ArrayList<Point>();
        float[] averageParent = null;
        float midSpacing = vSpacing / 2.0f;
        float centerX = (egoX + alterX) / 2.0f;
        switch (relationType) {
            case ancestor: {
                averageParent = averageParentPassed == null ? new float[]{alterX, alterY} : averageParentPassed;
                egoYmid = egoY - midSpacing;
                alterYmid = averageParent[1] + 30.0f;
                centerX = egoYmid < alterYmid ? centerX : egoX;
                centerX = egoY < alterY && egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            case descendant: {
                throw new OldFormatException("This diagram needs to be updated, select recalculate diagram from the edit menu before continuing.");
            }
            case sibling: {
                egoYmid = egoY - midSpacing;
                alterYmid = alterY - midSpacing;
                centerX = egoY < alterY ? alterX : egoX;
                centerX = egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            case union: {
                egoYmid = egoY + 30.0f;
                alterYmid = alterY + 30.0f;
                centerX = egoY < alterY ? egoX : alterX;
                centerX = egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            default: {
                egoYmid = egoY;
                alterYmid = alterY;
            }
        }
        initialPointsList.add(new Point((int)egoX, (int)egoY));
        initialPointsList.add(new Point((int)egoX, (int)egoYmid));
        if (averageParent != null) {
            float averageParentX = averageParent[0];
            initialPointsList.add(new Point((int)averageParentX, (int)egoYmid));
            initialPointsList.add(new Point((int)averageParentX, (int)alterYmid));
        } else {
            initialPointsList.add(new Point((int)centerX, (int)egoYmid));
            initialPointsList.add(new Point((int)centerX, (int)alterYmid));
        }
        if (averageParentPassed == null) {
            initialPointsList.add(new Point((int)alterX, (int)alterYmid));
            initialPointsList.add(new Point((int)alterX, (int)alterY));
        }
        return new LineRecord(lineIdString, initialPointsList);
    }

    private String setPathPointsAttribute(RelationTypeDefinition.CurveLineOrientation curveLineOrientation, float hSpacing, float vSpacing, float egoX, float egoY, float alterX, float alterY) {
        float toBezY;
        float fromBezY;
        float toBezX;
        float fromBezX;
        if (egoX > alterX && egoY < alterY || egoX > alterX && egoY > alterY) {
            float tempX = alterX;
            float tempY = alterY;
            alterX = egoX;
            alterY = egoY;
            egoX = tempX;
            egoY = tempY;
        }
        if (curveLineOrientation == RelationTypeDefinition.CurveLineOrientation.vertical) {
            fromBezX = egoX;
            toBezX = alterX;
            if (egoY > alterY) {
                if (egoY - alterY < hSpacing / 4.0f) {
                    fromBezY = egoY - hSpacing / 4.0f;
                    toBezY = alterY - hSpacing / 4.0f;
                } else {
                    fromBezY = (egoY - alterY) / 2.0f + alterY;
                    toBezY = (egoY - alterY) / 2.0f + alterY;
                }
            } else if (alterY - egoY < hSpacing / 4.0f) {
                fromBezY = egoY + hSpacing / 4.0f;
                toBezY = alterY + hSpacing / 4.0f;
            } else {
                fromBezY = (alterY - egoY) / 2.0f + egoY;
                toBezY = (alterY - egoY) / 2.0f + egoY;
            }
            float distanceX = Math.abs(egoX - alterX);
            if (distanceX < hSpacing / 4.0f) {
                boolean quadrantType = egoY > alterY == egoY > alterY;
                float curveToAdd = hSpacing / 8.0f;
                if (quadrantType) {
                    fromBezX -= curveToAdd;
                    toBezX += curveToAdd;
                } else {
                    fromBezX += curveToAdd;
                    toBezX -= curveToAdd;
                }
            }
        } else {
            fromBezY = egoY;
            toBezY = alterY;
            if (egoX > alterX) {
                if (egoX - alterX < hSpacing / 4.0f) {
                    fromBezX = egoX - hSpacing / 4.0f;
                    toBezX = alterX - hSpacing / 4.0f;
                } else {
                    fromBezX = (egoX - alterX) / 2.0f + alterX;
                    toBezX = (egoX - alterX) / 2.0f + alterX;
                }
            } else if (alterX - egoX < hSpacing / 4.0f) {
                fromBezX = egoX + hSpacing / 4.0f;
                toBezX = alterX + hSpacing / 4.0f;
            } else {
                fromBezX = (alterX - egoX) / 2.0f + egoX;
                toBezX = (alterX - egoX) / 2.0f + egoX;
            }
            float distanceY = Math.abs(egoY - alterY);
            if (distanceY < hSpacing / 4.0f) {
                boolean quadrantType = egoX > alterX == egoY > alterY;
                float curveToAdd = hSpacing / 8.0f;
                if (quadrantType) {
                    fromBezY -= curveToAdd;
                    toBezY += curveToAdd;
                } else {
                    fromBezY += curveToAdd;
                    toBezY -= curveToAdd;
                }
            }
        }
        return "M " + egoX + "," + egoY + " C " + fromBezX + "," + fromBezY + " " + toBezX + "," + toBezY + " " + alterX + "," + alterY;
    }
}

