/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg.relationlines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.relationlines.LineLookUpTable;
import nl.mpi.kinnate.svg.relationlines.RelationRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationRecordTable {
    HashMap<String, RelationRecord> recordStore = new HashMap();
    LineLookUpTable lineLookUpTable;
    ArrayList<String> doneRelations = new ArrayList();

    public void addRecord(GraphPanel graphPanel, EntityData entityData, EntityRelation entityRelation, int hSpacing, int vSpacing, int lineWidth) throws OldFormatException {
        EntityData rightEntity;
        EntityData leftEntity;
        DataTypes.RelationType directedRelation = entityRelation.getRelationType();
        if (entityRelation.getRelationType() == DataTypes.RelationType.descendant) {
            directedRelation = DataTypes.RelationType.ancestor;
            leftEntity = entityRelation.getAlterNode();
            rightEntity = entityData;
        } else if (entityRelation.getRelationType() == DataTypes.RelationType.ancestor) {
            leftEntity = entityData;
            rightEntity = entityRelation.getAlterNode();
        } else if (entityData.getUniqueIdentifier().getQueryIdentifier().compareTo(entityRelation.getAlterNode().getUniqueIdentifier().getQueryIdentifier()) > 0) {
            leftEntity = entityRelation.getAlterNode();
            rightEntity = entityData;
        } else {
            leftEntity = entityData;
            rightEntity = entityRelation.getAlterNode();
        }
        String compoundIdentifier = directedRelation == DataTypes.RelationType.ancestor ? "commonparent:" + leftEntity.getUniqueIdentifier().getQueryIdentifier() + directedRelation.name() + ":" + entityRelation.dcrType + ":" + entityRelation.customType : leftEntity.getUniqueIdentifier().getQueryIdentifier() + rightEntity.getUniqueIdentifier().getQueryIdentifier() + directedRelation.name() + ":" + entityRelation.dcrType + ":" + entityRelation.customType;
        if (!this.doneRelations.contains(compoundIdentifier)) {
            boolean skipCurrentRelation = false;
            if (DataTypes.isSanguinLine(entityRelation.getRelationType()) && this.hasCommonParent(leftEntity, entityRelation)) {
                skipCurrentRelation = true;
            }
            if (!skipCurrentRelation) {
                this.doneRelations.add(compoundIdentifier);
                String lineColour = entityRelation.lineColour;
                RelationTypeDefinition.CurveLineOrientation curveLineOrientation = RelationTypeDefinition.CurveLineOrientation.horizontal;
                int lineDash = 0;
                if (lineColour == null) {
                    for (RelationTypeDefinition relationTypeDefinition : graphPanel.dataStoreSvg.getRelationTypeDefinitions()) {
                        if (!relationTypeDefinition.matchesType(entityRelation)) continue;
                        lineColour = relationTypeDefinition.getLineColour();
                        lineWidth = relationTypeDefinition.getLineWidth();
                        curveLineOrientation = relationTypeDefinition.getCurveLineOrientation();
                        lineDash = relationTypeDefinition.getLineDash();
                        break;
                    }
                }
                RelationRecord relationRecord = new RelationRecord(graphPanel, this.size(), leftEntity, rightEntity, directedRelation, lineWidth, lineDash, curveLineOrientation, lineColour, entityRelation.labelString, hSpacing, vSpacing);
                this.recordStore.put(relationRecord.lineIdString, relationRecord);
            }
        }
    }

    public boolean hasCommonParent(EntityData currentNode, EntityRelation graphLinkNode) {
        if (graphLinkNode.getRelationType() == DataTypes.RelationType.sibling) {
            for (EntityRelation altersRelation : graphLinkNode.getAlterNode().getAllRelations()) {
                if (altersRelation.getRelationType() != DataTypes.RelationType.ancestor) continue;
                for (EntityRelation egosRelation : currentNode.getAllRelations()) {
                    if (egosRelation.getRelationType() != DataTypes.RelationType.ancestor || !altersRelation.alterUniqueIdentifier.equals(egosRelation.alterUniqueIdentifier) || altersRelation.getAlterNode() == null || !altersRelation.getAlterNode().isVisible) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public RelationRecord getRecord(String idString) {
        return this.recordStore.get(idString);
    }

    public Collection<RelationRecord> getAllRecords() {
        return this.recordStore.values();
    }

    public ArrayList<RelationRecord> getRecordsForSelection(ArrayList<UniqueIdentifier> selectedIdentifiers) {
        ArrayList<RelationRecord> returnRecords = new ArrayList<RelationRecord>();
        for (RelationRecord relationRecord : this.recordStore.values()) {
            if (!relationRecord.pertainsToEntity(selectedIdentifiers)) continue;
            returnRecords.add(relationRecord);
        }
        return returnRecords;
    }

    public int size() {
        return this.recordStore.size();
    }

    public void adjustLines() throws OldFormatException {
        this.lineLookUpTable = new LineLookUpTable();
        for (RelationRecord relationRecord : this.recordStore.values()) {
            relationRecord.updatePathPoints(this.lineLookUpTable);
        }
        this.lineLookUpTable.separateOverlappingLines();
        this.lineLookUpTable.addLoops();
    }
}

