/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.entityindexer.ParameterElement;

public class IndexerParam {
    @XmlTransient
    IndexerParameters indexerParameters;
    @XmlElement(name="IndexerParam", namespace="http://mpi.nl/tla/kin")
    private ArrayList<ParameterElement> parametersList;
    @XmlTransient
    private String[] availableValuesArray = null;

    public IndexerParam() {
    }

    public IndexerParam(String[][] valuesArrayLocal) {
        this.parametersList = new ArrayList();
        for (String[] currentValue : valuesArrayLocal) {
            this.parametersList.add(new ParameterElement(currentValue));
        }
    }

    public void setParent(IndexerParameters indexerParametersLocal) {
        this.indexerParameters = indexerParametersLocal;
    }

    public void setValues(String[][] valuesArrayLocal) {
        this.parametersList.clear();
        for (String[] currentValue : valuesArrayLocal) {
            this.parametersList.add(new ParameterElement(currentValue[0], currentValue[1]));
        }
        this.indexerParameters.valuesChanged = true;
    }

    public void setValue(String parameterString, String valueString) {
        if (valueString != null && valueString.length() == 0) {
            valueString = this.availableValuesArray[0];
        }
        this.indexerParameters.valuesChanged = true;
        for (ParameterElement currentEntry : this.parametersList) {
            if (!currentEntry.xpathString.equals(parameterString)) continue;
            currentEntry.selectedValue = valueString;
            return;
        }
        this.parametersList.add(new ParameterElement(parameterString, valueString));
    }

    public void removeValue(String pathToRemove) {
        ArrayList<ParameterElement> tempParametersList = new ArrayList<ParameterElement>();
        for (ParameterElement currentEntry : this.parametersList) {
            if (currentEntry.getXpathString().equals(pathToRemove)) continue;
            tempParametersList.add(currentEntry);
        }
        this.parametersList = tempParametersList;
        this.indexerParameters.valuesChanged = true;
    }

    @XmlTransient
    public ParameterElement[] getValues() {
        return this.parametersList.toArray(new ParameterElement[0]);
    }

    @XmlTransient
    public void setAvailableValues(String[] availableValuesArrayLocal) {
        this.availableValuesArray = availableValuesArrayLocal;
    }

    public String[] getAvailableValues() {
        return this.availableValuesArray;
    }
}

