/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.templates.ArbilFavourites;

public class FavouriteSelectBox
extends JPanel {
    final ArbilNode targetNode;
    final JCheckBox metadataFilePerResourceCheckBox;
    final JCheckBox copyDirectoryStructureCheckBox;
    final JList favouriteList;

    public FavouriteSelectBox(ArbilNode targetNode) {
        this.targetNode = targetNode;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Suitable Favourites"));
        this.favouriteList = new JList<ArbilDataNode>(ArbilFavourites.getSingleInstance().listFavouritesFor(targetNode));
        this.favouriteList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String labelString = value.toString();
                if (labelString.length() > 50) {
                    labelString = labelString.substring(0, 48) + "...";
                }
                listCellRendererComponent.setText(labelString);
                listCellRendererComponent.setIcon(((ArbilDataNode)value).getIcon());
                return listCellRendererComponent;
            }
        });
        this.add((Component)new JScrollPane(this.favouriteList), "Center");
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 3));
        this.metadataFilePerResourceCheckBox = new JCheckBox("Metadata for each resource", false);
        optionsPanel.add(this.metadataFilePerResourceCheckBox);
        this.copyDirectoryStructureCheckBox = new JCheckBox("Copy directory structure", false);
        optionsPanel.add(this.copyDirectoryStructureCheckBox);
        this.add((Component)optionsPanel, "Last");
    }

    public ArbilDataNode getSelectedFavouriteNode() {
        return (ArbilDataNode)this.favouriteList.getSelectedValue();
    }

    public ArbilNode getTargetNode() {
        return this.targetNode;
    }

    public boolean getCopyDirectoryStructure() {
        return this.copyDirectoryStructureCheckBox.isSelected();
    }

    public boolean getMetadataFilePerResource() {
        return this.metadataFilePerResourceCheckBox.isSelected();
    }
}

