/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.help.HelpIndex;
import nl.mpi.arbil.help.HelpItem;
import nl.mpi.arbil.help.HelpItemsParser;
import nl.mpi.arbil.ui.ArbilHyperlinkListener;
import nl.mpi.arbil.util.BugCatcherManager;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpViewerPanel
extends JPanel {
    public static final String SHOTCUT_KEYS_PAGE = "Shortcut Keys";
    public static final String INTRODUCTION_PAGE = "Overview";
    public static final String helpWindowTitle = "Help Viewer";
    public static final String DEFAULT_HELPSET = "Help";
    private JTabbedPane tabbedPane;
    private JScrollPane helpTextScrollPane;
    private JSplitPane jSplitPane1;
    private JTextPane helpTextPane;
    private HelpTree currentTree;
    private final Map<String, HelpTree> helpTreesMap;
    private final List<HelpTree> helpTrees;

    public HelpViewerPanel(Class resourcesClass, String helpResourceBase, String indexXml) throws IOException, SAXException {
        this(Collections.singletonList(new HelpResourceSet(DEFAULT_HELPSET, resourcesClass, helpResourceBase, indexXml)));
    }

    public HelpViewerPanel(List<HelpResourceSet> helpSets) throws IOException, SAXException {
        if (helpSets.size() < 1) {
            throw new IllegalArgumentException("Should provide at least one help resource set");
        }
        this.initComponents();
        HelpItemsParser parser = new HelpItemsParser();
        this.helpTrees = new ArrayList<HelpTree>(helpSets.size());
        this.helpTreesMap = new HashMap<String, HelpTree>(helpSets.size());
        for (HelpResourceSet helpSet : helpSets) {
            HelpTree helpTree = this.createHelpTree(helpSet, parser);
            this.helpTrees.add(helpTree);
            this.helpTreesMap.put(helpSet.getName(), helpTree);
        }
        this.currentTree = this.helpTrees.get(0);
        this.initIndexPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HelpTree createHelpTree(HelpResourceSet helpSet, HelpItemsParser parser) throws SAXException, IOException {
        HelpTree helpTree = new HelpTree(helpSet);
        this.initHelpTreeComponents(helpTree);
        InputStream helpStream = helpSet.getResourcesClass().getResourceAsStream(helpSet.getIndexXml());
        if (helpStream != null) {
            try {
                helpTree.setHelpIndex(parser.parse(helpStream));
            }
            finally {
                helpStream.close();
            }
        } else {
            HelpIndex helpIndex = new HelpIndex();
            HelpItem helpItem = new HelpItem();
            helpItem.setName("Help contents not found");
            helpIndex.addSubItem(helpItem);
            helpTree.setHelpIndex(helpIndex);
        }
        helpTree.getIndexTree().getSelectionModel().setSelectionMode(1);
        helpTree.setRootContentsNode(new DefaultMutableTreeNode("Contents"));
        helpTree.setHelpTreeModel(new DefaultTreeModel(helpTree.getRootContentsNode(), true));
        helpTree.getIndexTree().setModel(helpTree.getHelpTreeModel());
        this.populateIndex(helpTree);
        return helpTree;
    }

    private HelpTree getHelpTree(String resourceSetName) {
        return this.helpTreesMap.get(resourceSetName);
    }

    public void setCurrentPage(String helpSet, String helpPage) {
        HelpItem helpFile = this.getHelpFileByName(this.getHelpTree(helpSet).getHelpIndex(), helpPage);
        if (helpFile != null) {
            this.showHelpItem(this.getHelpTree(helpSet), helpFile.getFile());
        } else {
            BugCatcherManager.getBugCatcher().logError(new Exception("Help page not found: " + helpPage));
        }
    }

    private HelpItem getHelpFileByName(HelpIndex parentItem, String name) {
        for (HelpItem child : parentItem.getSubItems()) {
            if (child.getName().replaceAll("^\\d+\\.", "").trim().equals(name)) {
                return child;
            }
            HelpItem childResult = this.getHelpFileByName(child, name);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    private void populateIndex(HelpTree tree) {
        DefaultMutableTreeNode rootNode = tree.getRootContentsNode();
        for (HelpItem item : tree.getHelpIndex().getSubItems()) {
            this.populateIndex(rootNode, item);
        }
        tree.getHelpTreeModel().reload(rootNode);
    }

    private void populateIndex(DefaultMutableTreeNode parent, HelpItem item) {
        DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(item, item.getSubItems().size() > 0);
        parent.add(itemNode);
        for (HelpItem subItem : item.getSubItems()) {
            this.populateIndex(itemNode, subItem);
        }
    }

    private void initComponents() {
        this.helpTextPane = new JTextPane();
        this.helpTextPane.addHyperlinkListener(new ArbilHyperlinkListener());
        this.helpTextPane.setMinimumSize(new Dimension(100, 100));
        this.helpTextPane.setContentType("text/html;charset=UTF-8");
        this.helpTextPane.setEditable(false);
        this.helpTextScrollPane = new JScrollPane();
        this.helpTextScrollPane.setViewportView(this.helpTextPane);
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setRightComponent(this.helpTextScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void initHelpTreeComponents(HelpTree helpTree) {
        JTree indexTree = new JTree();
        indexTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                HelpViewerPanel.this.indexTreeValueChanged();
            }
        });
        helpTree.setIndexTree(indexTree);
        JScrollPane indexScrollPane = new JScrollPane();
        indexScrollPane.setViewportView(indexTree);
        helpTree.setIndexScrollPane(indexScrollPane);
    }

    private void initIndexPane() {
        if (this.helpTrees.size() > 1) {
            this.initHelpTreeTabs();
        } else {
            this.jSplitPane1.setLeftComponent(this.currentTree.getIndexScrollPane());
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(this.currentTree.getHelpResourceSet().getResourcesClass().getResource(this.currentTree.getHelpResourceSet().getHelpResourceBase()));
        }
    }

    private void initHelpTreeTabs() {
        this.tabbedPane = new JTabbedPane();
        for (HelpTree tree : this.helpTrees) {
            this.tabbedPane.add(tree.getHelpResourceSet().getName(), tree.getIndexScrollPane());
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                HelpViewerPanel.this.updateTabState();
            }
        });
        this.jSplitPane1.setLeftComponent(this.tabbedPane);
        this.updateTabState();
    }

    private void updateTabState() {
        if (this.tabbedPane != null) {
            this.currentTree = this.helpTrees.get(this.tabbedPane.getSelectedIndex());
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(this.currentTree.getHelpResourceSet().getResourcesClass().getResource(this.currentTree.getHelpResourceSet().getHelpResourceBase()));
            if (this.currentTree.getIndexTree().getSelectionCount() == 0) {
                this.currentTree.getIndexTree().setSelectionRow(1);
            } else {
                this.indexTreeValueChanged();
            }
        }
    }

    private void indexTreeValueChanged() {
        Object nodeInfo;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.currentTree.getIndexTree().getLastSelectedPathComponent();
        if (node != null && (nodeInfo = node.getUserObject()) instanceof HelpItem) {
            this.showHelpItem(this.currentTree, ((HelpItem)nodeInfo).getFile());
        }
    }

    public boolean showHelpItem(URL itemURL) {
        return this.showHelpItem(DEFAULT_HELPSET, itemURL);
    }

    protected final boolean showHelpItem(String helpSetName, URL itemURL) {
        HelpTree helpTree = this.getHelpTree(helpSetName);
        HelpResourceSet helpSet = helpTree.getHelpResourceSet();
        try {
            URI relativeURI;
            String itemPath;
            URI baseUri = helpSet.getResourcesClass().getResource(helpSet.getHelpResourceBase()).toURI();
            if (itemURL.toString().startsWith(baseUri.toString()) && (itemPath = (relativeURI = this.getRelativeURI(baseUri, itemURL.toURI())).getPath()) != null) {
                return this.updateIndex(helpTree, itemPath.toString(), relativeURI.getFragment());
            }
        }
        catch (URISyntaxException usEx) {
            BugCatcherManager.getBugCatcher().logError(usEx);
        }
        return false;
    }

    private URI getRelativeURI(URI baseUri, URI itemURI) throws URISyntaxException {
        if (baseUri.getScheme().equals("jar") && itemURI.getScheme().equals("jar")) {
            URI baseInternalUri = new URI(baseUri.getSchemeSpecificPart());
            URI itemInternalUri = new URI(itemURI.getSchemeSpecificPart());
            return baseInternalUri.relativize(itemInternalUri);
        }
        return baseUri.relativize(itemURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHelpItem(HelpTree helpTree, String itemResource) {
        HelpResourceSet helpSet = helpTree.getHelpResourceSet();
        StringBuilder completeHelpText = new StringBuilder();
        InputStream itemStream = helpSet.getResourcesClass().getResourceAsStream(helpSet.getHelpResourceBase() + itemResource);
        if (itemStream == null) {
            completeHelpText.append("Page not found");
        } else {
            try {
                BufferedReader bufferedHelpReader = new BufferedReader(new InputStreamReader(itemStream, "UTF-8"));
                try {
                    String helpLine = bufferedHelpReader.readLine();
                    while (helpLine != null) {
                        completeHelpText.append(helpLine);
                        helpLine = bufferedHelpReader.readLine();
                    }
                }
                catch (IOException ioEx) {
                    completeHelpText.append("<p><strong>I/O exception while reading help contents</strong></p>");
                    BugCatcherManager.getBugCatcher().logError(ioEx);
                }
                finally {
                    try {
                        bufferedHelpReader.close();
                    }
                    catch (IOException ioEx) {
                        completeHelpText.append("<p><strong>I/O exception while close stream</strong></p>");
                        BugCatcherManager.getBugCatcher().logError(ioEx);
                    }
                }
            }
            catch (UnsupportedEncodingException ueEx) {
                completeHelpText.append("<p><strong>I/O exception while close stream</strong></p>");
                BugCatcherManager.getBugCatcher().logError(ueEx);
            }
        }
        this.helpTextPane.setText(completeHelpText.toString());
        this.helpTextPane.setCaretPosition(0);
        this.updateIndex(helpTree, itemResource);
    }

    private boolean updateIndex(HelpTree tree, String itemResource, final String fragment) {
        if (this.updateIndex(tree, itemResource)) {
            if (fragment != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HelpViewerPanel.this.helpTextPane.scrollToReference(fragment);
                    }
                });
            }
            return true;
        }
        return false;
    }

    private boolean updateIndex(HelpTree tree, String itemResource) {
        HelpItem helpItem;
        if (itemResource == null) {
            return false;
        }
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)tree.getIndexTree().getSelectionPath().getLastPathComponent();
        if (lastPathComponent.getUserObject() instanceof HelpItem && itemResource.equals((helpItem = (HelpItem)lastPathComponent.getUserObject()).getFile())) {
            return true;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getIndexTree().getModel().getRoot();
        DefaultMutableTreeNode selectionItem = this.findChild(root, itemResource);
        if (selectionItem != null) {
            TreePath treePath = new TreePath(selectionItem.getPath());
            tree.getIndexTree().setSelectionPath(treePath);
            tree.getIndexTree().scrollPathToVisible(treePath);
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode findChild(DefaultMutableTreeNode root, String itemResource) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            HelpItem helpItem;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)root.getChildAt(i);
            Object userObject = childNode.getUserObject();
            if (userObject instanceof HelpItem && (helpItem = (HelpItem)userObject).getFile().equals(itemResource)) {
                return childNode;
            }
            DefaultMutableTreeNode findChild = this.findChild(childNode, itemResource);
            if (findChild == null) continue;
            return findChild;
        }
        return null;
    }

    private static class HelpTree {
        private final HelpResourceSet helpResourceSet;
        private HelpIndex helpIndex;
        private JTree indexTree;
        private DefaultTreeModel helpTreeModel;
        private DefaultMutableTreeNode rootContentsNode;
        private JScrollPane indexScrollPane;

        public JScrollPane getIndexScrollPane() {
            return this.indexScrollPane;
        }

        public void setIndexScrollPane(JScrollPane indexScrollPane) {
            this.indexScrollPane = indexScrollPane;
        }

        public DefaultTreeModel getHelpTreeModel() {
            return this.helpTreeModel;
        }

        public void setHelpTreeModel(DefaultTreeModel helpTreeModel) {
            this.helpTreeModel = helpTreeModel;
        }

        public DefaultMutableTreeNode getRootContentsNode() {
            return this.rootContentsNode;
        }

        public void setRootContentsNode(DefaultMutableTreeNode rootContentsNode) {
            this.rootContentsNode = rootContentsNode;
        }

        public HelpTree(HelpResourceSet helpResourceSet) {
            this.helpResourceSet = helpResourceSet;
        }

        public HelpIndex getHelpIndex() {
            return this.helpIndex;
        }

        public void setHelpIndex(HelpIndex helpIndex) {
            this.helpIndex = helpIndex;
        }

        public JTree getIndexTree() {
            return this.indexTree;
        }

        public void setIndexTree(JTree indexTree) {
            this.indexTree = indexTree;
        }

        public HelpResourceSet getHelpResourceSet() {
            return this.helpResourceSet;
        }
    }

    public static class HelpResourceSet {
        private final String name;
        private final Class resourcesClass;
        private final String helpResourceBase;
        private final String indexXml;

        public HelpResourceSet(String name, Class resourcesClass, String helpResourceBase, String indexXml) {
            this.name = name;
            this.resourcesClass = resourcesClass;
            this.helpResourceBase = helpResourceBase;
            this.indexXml = indexXml;
        }

        public String getName() {
            return this.name;
        }

        public Class getResourcesClass() {
            return this.resourcesClass;
        }

        public String getHelpResourceBase() {
            return this.helpResourceBase;
        }

        public String getIndexXml() {
            return this.indexXml;
        }
    }
}

