/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.util.UnitConv;

public class PCLPageDefinition {
    private static List pageDefinitions;
    private static PCLPageDefinition defaultPageDefinition;
    private String name;
    private int selector;
    private Dimension physicalPageSize;
    private Rectangle logicalPageRect;
    private boolean landscape;

    public PCLPageDefinition(String name, int selector, Dimension physicalPageSize, Rectangle logicalPageRect, boolean landscape) {
        this.name = name;
        this.selector = selector;
        this.physicalPageSize = physicalPageSize;
        this.logicalPageRect = logicalPageRect;
        this.landscape = landscape;
    }

    public String getName() {
        return this.name;
    }

    public int getSelector() {
        return this.selector;
    }

    public boolean isLandscapeFormat() {
        return this.landscape;
    }

    public Dimension getPhysicalPageSize() {
        return this.physicalPageSize;
    }

    public Rectangle getLogicalPageRect() {
        return this.logicalPageRect;
    }

    private boolean matches(long width, long height, int errorMargin) {
        return Math.abs((long)this.physicalPageSize.width - width) < (long)errorMargin && Math.abs((long)this.physicalPageSize.height - height) < (long)errorMargin;
    }

    public String toString() {
        return this.getName();
    }

    public static PCLPageDefinition getPageDefinition(long width, long height, int errorMargin) {
        Iterator iter = pageDefinitions.iterator();
        while (iter.hasNext()) {
            PCLPageDefinition def = (PCLPageDefinition)iter.next();
            if (!def.matches(width, height, errorMargin)) continue;
            return def;
        }
        return null;
    }

    public static PCLPageDefinition getDefaultPageDefinition() {
        return defaultPageDefinition;
    }

    private static int convert300dpiDotsToMpt(int offset) {
        return (int)Math.round((double)offset * 72000.0 / 300.0);
    }

    private static Dimension createPhysicalPageSizeInch(float width, float height) {
        return new Dimension((int)Math.round(UnitConv.in2mpt(width)), (int)Math.round(UnitConv.in2mpt(height)));
    }

    private static Dimension createPhysicalPageSizeMm(float width, float height) {
        return new Dimension((int)Math.round(UnitConv.mm2mpt(width)), (int)Math.round(UnitConv.mm2mpt(height)));
    }

    private static Rectangle createLogicalPageRect(int x, int y, int width, int height) {
        return new Rectangle(PCLPageDefinition.convert300dpiDotsToMpt(x), PCLPageDefinition.convert300dpiDotsToMpt(y), PCLPageDefinition.convert300dpiDotsToMpt(width), PCLPageDefinition.convert300dpiDotsToMpt(height));
    }

    private static void createPageDefinitions() {
        pageDefinitions = new ArrayList();
        pageDefinitions.add(new PCLPageDefinition("Letter", 2, PCLPageDefinition.createPhysicalPageSizeInch(8.5f, 11.0f), PCLPageDefinition.createLogicalPageRect(75, 0, 2400, 3300), false));
        defaultPageDefinition = new PCLPageDefinition("Legal", 3, PCLPageDefinition.createPhysicalPageSizeInch(8.5f, 14.0f), PCLPageDefinition.createLogicalPageRect(75, 0, 2400, 4200), false);
        pageDefinitions.add(defaultPageDefinition);
        pageDefinitions.add(new PCLPageDefinition("Executive", 1, PCLPageDefinition.createPhysicalPageSizeInch(7.25f, 10.5f), PCLPageDefinition.createLogicalPageRect(75, 0, 2025, 3150), false));
        pageDefinitions.add(new PCLPageDefinition("Ledger", 6, PCLPageDefinition.createPhysicalPageSizeInch(11.0f, 17.0f), PCLPageDefinition.createLogicalPageRect(75, 0, 3150, 5100), false));
        pageDefinitions.add(new PCLPageDefinition("A4", 26, PCLPageDefinition.createPhysicalPageSizeMm(210.0f, 297.0f), PCLPageDefinition.createLogicalPageRect(71, 0, 2338, 3507), false));
        pageDefinitions.add(new PCLPageDefinition("A3", 27, PCLPageDefinition.createPhysicalPageSizeMm(297.0f, 420.0f), PCLPageDefinition.createLogicalPageRect(71, 0, 3365, 4960), false));
        pageDefinitions.add(new PCLPageDefinition("LetterL", 2, PCLPageDefinition.createPhysicalPageSizeInch(11.0f, 8.5f), PCLPageDefinition.createLogicalPageRect(60, 0, 3180, 2550), true));
        pageDefinitions.add(new PCLPageDefinition("LegalL", 3, PCLPageDefinition.createPhysicalPageSizeInch(14.0f, 8.5f), PCLPageDefinition.createLogicalPageRect(60, 0, 4080, 2550), true));
        pageDefinitions.add(new PCLPageDefinition("ExecutiveL", 1, PCLPageDefinition.createPhysicalPageSizeInch(10.5f, 7.25f), PCLPageDefinition.createLogicalPageRect(60, 0, 3030, 2175), true));
        pageDefinitions.add(new PCLPageDefinition("LedgerL", 6, PCLPageDefinition.createPhysicalPageSizeInch(17.0f, 11.0f), PCLPageDefinition.createLogicalPageRect(60, 0, 4980, 3300), true));
        pageDefinitions.add(new PCLPageDefinition("A4L", 26, PCLPageDefinition.createPhysicalPageSizeMm(297.0f, 210.0f), PCLPageDefinition.createLogicalPageRect(59, 0, 3389, 2480), true));
        pageDefinitions.add(new PCLPageDefinition("A3L", 27, PCLPageDefinition.createPhysicalPageSizeMm(420.0f, 297.0f), PCLPageDefinition.createLogicalPageRect(59, 0, 4842, 3507), true));
    }

    static {
        PCLPageDefinition.createPageDefinitions();
    }
}

