/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.text.linebreak;

import org.apache.fop.text.linebreak.LineBreakUtils;

public class LineBreakStatus {
    public static final byte DIRECT_BREAK = 0;
    public static final byte INDIRECT_BREAK = 1;
    public static final byte COMBINING_INDIRECT_BREAK = 2;
    public static final byte COMBINING_PROHIBITED_BREAK = 3;
    public static final byte PROHIBITED_BREAK = 4;
    public static final byte EXPLICIT_BREAK = 5;
    private byte leftClass;
    private boolean hadSpace;

    public LineBreakStatus() {
        this.reset();
    }

    public void reset() {
        this.leftClass = (byte)-1;
        this.hadSpace = false;
    }

    public byte nextChar(char c) {
        int currentClass = LineBreakUtils.getLineBreakProperty(c);
        if (currentClass == 1 || this.leftClass == 35) {
            currentClass = 2;
        } else if (currentClass == 23) {
            currentClass = 6;
        }
        if (this.leftClass == -1) {
            if (currentClass == 22) {
                this.leftClass = (byte)6;
            } else {
                this.leftClass = (byte)currentClass;
                if (this.leftClass == 9) {
                    this.leftClass = (byte)16;
                }
            }
            return 4;
        }
        if (this.leftClass == 6 || this.leftClass == 10 && currentClass != 22) {
            this.reset();
            if (currentClass == 22) {
                this.leftClass = (byte)6;
            }
            return 5;
        }
        if (currentClass == 6 || currentClass == 22) {
            this.leftClass = (byte)6;
            return 4;
        }
        if (currentClass == 10) {
            this.leftClass = (byte)10;
            return 4;
        }
        if (currentClass == 32) {
            this.hadSpace = true;
            return 4;
        }
        boolean savedHadSpace = this.hadSpace;
        this.hadSpace = false;
        switch (LineBreakUtils.getLineBreakPairProperty(this.leftClass, currentClass)) {
            case 4: {
                this.leftClass = (byte)currentClass;
                return 4;
            }
            case 0: {
                this.leftClass = (byte)currentClass;
                return 0;
            }
            case 1: {
                this.leftClass = (byte)currentClass;
                if (savedHadSpace) {
                    return 1;
                }
                return 4;
            }
            case 2: {
                if (savedHadSpace) {
                    this.leftClass = (byte)currentClass;
                    return 2;
                }
                return 4;
            }
            case 3: {
                if (savedHadSpace) {
                    this.leftClass = (byte)currentClass;
                }
                return 3;
            }
        }
        throw new RuntimeException("duh");
    }
}

