/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugin;

import java.io.IOException;
import java.util.Properties;
import nl.mpi.arbil.plugin.PluginException;
import nl.mpi.kinnate.plugin.BasePlugin;

public abstract class AbstractBasePlugin
implements BasePlugin {
    private final String nameString;
    private final String descriptionString;
    private final int majorVersionNumber;
    private final int minorVersionNumber;
    private final int buildVersionNumber;
    private final String compileDateString;
    private final String artifactVersionString;
    private final String lastCommitDate;

    public AbstractBasePlugin(String nameString, String descriptionString, String packageString) throws PluginException {
        this.nameString = nameString;
        this.descriptionString = descriptionString;
        Properties properties = new Properties();
        try {
            String propertiesPath = packageString.replace(".", "/");
            properties.load(this.getClass().getResourceAsStream("/" + propertiesPath + "/version.properties"));
            this.majorVersionNumber = Integer.parseInt(properties.getProperty("plugin.majorVersion"));
            this.minorVersionNumber = Integer.parseInt(properties.getProperty("plugin.minorVersion"));
            this.buildVersionNumber = Integer.parseInt(properties.getProperty("plugin.buildVersion"));
            this.lastCommitDate = properties.getProperty("plugin.lastCommitDate");
            this.compileDateString = properties.getProperty("plugin.compileDate");
            this.artifactVersionString = properties.getProperty("plugin.projectVersion");
        }
        catch (IOException ex) {
            throw new PluginException("Version properties could not be read!");
        }
    }

    public String getName() {
        return this.nameString;
    }

    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public int getBuildVersionNumber() {
        return this.buildVersionNumber;
    }

    public String getCompileDate() {
        return this.compileDateString;
    }

    public String getLastCommitDate() {
        return this.lastCommitDate;
    }

    public String getArtifactVersion() {
        return this.artifactVersionString;
    }

    public String getDescription() {
        return this.descriptionString;
    }

    public boolean isMavenVersionCorrect() throws PluginException {
        String errorMessage = "The maven version does not match either the snapshot nor the current svn build number.\n The pom.xml must be updated, please use either the correct build number or a snapshot version.";
        String svnVersion = this.getMajorVersionNumber() + "." + this.getMinorVersionNumber() + "." + this.getBuildVersionNumber() + "-";
        System.out.println("svnVersion: " + svnVersion + " ... ");
        String snapshotVersion = this.getMajorVersionNumber() + "." + this.getMinorVersionNumber() + "-";
        System.out.println("snapshotVersion: " + snapshotVersion + " ... " + "-SNAPSHOT");
        String mavenBuildVersion = this.getArtifactVersion();
        System.out.println("mavenBuildVersion: " + mavenBuildVersion);
        if (mavenBuildVersion.endsWith("-SNAPSHOT")) {
            if (mavenBuildVersion.startsWith(snapshotVersion)) {
                return true;
            }
            throw new PluginException(errorMessage);
        }
        if (mavenBuildVersion.startsWith(svnVersion)) {
            return true;
        }
        throw new PluginException(errorMessage);
    }
}

