/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.core.cmd.AUser;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.util.Util;

public final class Grant
extends AUser {
    private int prm = -1;

    public Grant(Object perm, String user) {
        this(perm, user, null);
    }

    public Grant(Object perm, String user, String db) {
        super(perm.toString(), user, db);
    }

    @Override
    protected boolean run() {
        Commands.CmdPerm cmd = this.getOption(Commands.CmdPerm.class);
        if (cmd == Commands.CmdPerm.NONE) {
            this.prm = 0;
        } else if (cmd == Commands.CmdPerm.READ) {
            this.prm = 1;
        } else if (cmd == Commands.CmdPerm.WRITE) {
            this.prm = 2;
        } else if (cmd == Commands.CmdPerm.CREATE && this.args[2] == null) {
            this.prm = 4;
        } else if (cmd == Commands.CmdPerm.ADMIN && this.args[2] == null) {
            this.prm = 8;
        }
        if (this.prm == -1) {
            return this.error(Text.PERMINV, this.args[0]);
        }
        return this.run(1, false);
    }

    @Override
    protected boolean run(String user, String db) {
        if (user.equals("admin")) {
            return !this.info(Text.USERADMIN, new Object[0]);
        }
        if (db == null) {
            this.context.users.get((String)user).perm = this.prm;
            this.context.users.write();
            return this.info(Text.GRANT, this.args[0], user);
        }
        try {
            Data data = Open.open(db, this.context);
            User u = data.meta.users.get(user);
            if (u == null) {
                u = this.context.users.get(user).copy();
                data.meta.users.create(u);
            }
            u.perm = this.prm;
            data.meta.dirty = true;
            data.flush();
            Close.close(data, this.context);
            return this.info(Text.GRANTON, this.args[0], user, db);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return !this.info(msg.isEmpty() ? Text.DBOPENERR : msg, db);
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init().arg(0).arg("ON", 2).arg("TO", 1);
    }
}

