/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

public final class Performance {
    private long time = System.nanoTime();

    public long getTime() {
        long time2 = System.nanoTime();
        long diff = time2 - this.time;
        this.time = time2;
        return diff;
    }

    public String getTimer() {
        return this.getTimer(1);
    }

    public String getTimer(int runs) {
        long time2 = System.nanoTime();
        String t = Performance.getTimer(time2 - this.time, runs);
        this.time = time2;
        return t;
    }

    public static String getTimer(long time, int runs) {
        return String.valueOf((double)(time / (long)runs / 10000L) / 100.0) + " ms" + (runs > 1 ? " (avg)" : "");
    }

    public static String getMem() {
        return Performance.format(Performance.mem());
    }

    public static String format(long size) {
        return Performance.format(size, true, 5);
    }

    public static String format(long size, boolean det) {
        return Performance.format(size, det, 0);
    }

    private static String format(long size, boolean det, int off) {
        if (size > 1L << 30 + off) {
            return String.valueOf(size + 0x20000000L >> 30) + " GB";
        }
        if (size > 1L << 20 + off) {
            return String.valueOf(size + 524288L >> 20) + " MB";
        }
        if (size > 1L << 10 + off) {
            return String.valueOf(size + 512L >> 10) + " KB";
        }
        return String.valueOf(size) + (det ? " Byte" + (size == 1L ? "" : "s") : " B");
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void gc(int n) {
        int i = 0;
        while (i < n) {
            System.gc();
            ++i;
        }
    }

    public static long mem() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public String toString() {
        return this.getTimer();
    }
}

