/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class DocumentNewMenu
extends JMenu
implements ActionListener {
    private final AbstractDiagramManager diagramWindowManager;
    private final Component parentComponent;

    public DocumentNewMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        for (DocumentType documentType : DocumentType.values()) {
            JMenuItem menuItem = new JMenuItem(documentType.getDisplayName());
            menuItem.setActionCommand(documentType.name());
            menuItem.addActionListener(this);
            this.add(menuItem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        DocumentType documentType = DocumentType.valueOf(e.getActionCommand());
        Dimension parentSize = this.parentComponent.getSize();
        Point parentLocation = this.parentComponent.getLocation();
        int offset = 10;
        Rectangle windowRectangle = new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset);
        this.diagramWindowManager.newDiagram(documentType, windowRectangle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocumentType {
        Simple("Standard Diagram (database driven)"),
        Freeform("Freeform Diagram (transient)"),
        KinTerms("Kin Terms Diagram"),
        Query("Query Diagram"),
        ArchiveLinker("Archive Data Linker");

        private String displayName;

        private DocumentType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

