/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bin;
import org.basex.query.item.Hex;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class B64
extends Bin {
    public B64(byte[] d, InputInfo ii) throws QueryException {
        super(B64.decode(d, ii), AtomType.B64);
    }

    public B64(byte[] d) {
        super(d, AtomType.B64);
    }

    B64(Hex h) {
        this(h.val);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.val, it instanceof Bin ? ((Bin)it).val : B64.decode(it.atom(ii), ii));
    }

    @Override
    public byte[] atom() {
        return Base64.encode(this.val);
    }

    private static byte[] decode(byte[] d, InputInfo ii) throws QueryException {
        try {
            return Base64.decode(d);
        }
        catch (IllegalArgumentException ex) {
            String chars = ex.getMessage().replaceAll(".*?: |\\.$", "");
            throw Err.FUNCAST.thrw(ii, AtomType.B64, chars);
        }
    }
}

