/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.TimerTask;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Main;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.server.ClientListener;
import org.basex.server.ClientSession;
import org.basex.server.LocalSession;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.StringList;

public final class BaseXServer
extends Main
implements Runnable {
    public volatile boolean running;
    ServerSocket esocket;
    IOFile stop;
    Log log;
    private EventListener events;
    private final TokenIntMap blocked = new TokenIntMap();
    private final HashSet<ClientListener> auth = new HashSet();
    private StringList commands;
    private boolean quiet;
    private boolean service;
    private volatile boolean stopped;
    private ServerSocket socket;

    public static void main(String[] args) {
        try {
            new BaseXServer(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXServer(String ... args) throws IOException {
        this((Context)null, args);
    }

    public BaseXServer(Context ctx, String ... args) throws IOException {
        super(args, ctx);
        InetAddress addr;
        MainProp mprop = this.context.mprop;
        int port = mprop.num(MainProp.SERVERPORT);
        int eport = mprop.num(MainProp.EVENTPORT);
        if (port == eport) {
            throw new BaseXException(Text.PORT_TWICE_X, port);
        }
        String host = mprop.get(MainProp.SERVERHOST);
        InetAddress inetAddress = addr = host.isEmpty() ? null : InetAddress.getByName(host);
        if (this.service) {
            BaseXServer.start(port, args);
            Util.outln(Text.SRV_STARTED, new Object[0]);
            Performance.sleep(1000L);
            return;
        }
        if (this.stopped) {
            BaseXServer.stop(port, eport);
            Util.outln(Text.SRV_STOPPED, new Object[0]);
            Performance.sleep(1000L);
            return;
        }
        try {
            for (String c : this.commands) {
                this.execute(c);
            }
            this.log = new Log(this.context, this.quiet);
            this.log.write(Text.SRV_STARTED);
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, port));
            this.esocket = new ServerSocket();
            this.esocket.setReuseAddress(true);
            this.esocket.bind(new InetSocketAddress(addr, eport));
            this.stop = BaseXServer.stopFile(port);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    BaseXServer.this.log.write(Text.SRV_STOPPED);
                    BaseXServer.this.log = null;
                    Util.outln(Text.SRV_STOPPED, new Object[0]);
                }
            });
            new Thread(this).start();
            while (!this.running) {
                Performance.sleep(10L);
            }
            Util.outln(Text.CONSOLE + (this.console ? Text.TRY_MORE_X : Text.SRV_STARTED), "Server");
            if (this.console) {
                this.console();
                this.quit();
            }
        }
        catch (IOException ex) {
            if (this.log != null) {
                this.log.error(ex);
            }
            throw ex;
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.socket.accept();
                if (this.stop.exists()) {
                    if (!this.stop.delete()) {
                        this.log.write(Util.info(Text.FILE_NOT_DELETED_X, this.stop));
                    }
                    this.quit();
                    continue;
                }
                long ka = (long)this.context.mprop.num(MainProp.KEEPALIVE) * 1000L;
                if (ka > 0L) {
                    long ms = System.currentTimeMillis();
                    for (ClientListener cs : this.context.sessions) {
                        if (ms - cs.last <= ka) continue;
                        cs.quit();
                    }
                }
                final ClientListener cl = new ClientListener(s, this.context, this.log, this);
                long to = (long)this.context.mprop.num(MainProp.KEEPALIVE) * 1000L;
                if (to > 0L) {
                    cl.auth.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            cl.quitAuth();
                        }
                    }, to);
                    this.auth.add(cl);
                }
                cl.start();
            }
            catch (SocketException ex) {
                break;
            }
            catch (Throwable ex) {
                if (this.log == null) break;
                this.log.error(ex);
                break;
            }
        }
    }

    private static IOFile stopFile(int port) {
        return new IOFile(Prop.TMP, Util.name(BaseXServer.class) + port);
    }

    @Override
    protected synchronized void quit() throws IOException {
        block6: {
            if (!this.running) {
                return;
            }
            this.running = false;
            for (ClientListener cs : this.auth) {
                this.remove(cs);
                cs.quitAuth();
            }
            for (ClientListener cs : this.context.sessions) {
                cs.quit();
            }
            super.quit();
            this.context.close();
            try {
                if (this.console) {
                    System.in.close();
                }
                this.esocket.close();
                this.socket.close();
            }
            catch (IOException ex) {
                if (this.log == null) break block6;
                this.log.error(ex);
            }
        }
        this.console = false;
    }

    @Override
    protected Session session() {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        return this.session;
    }

    @Override
    protected void parseArguments(String ... args) throws IOException {
        Args arg = new Args(args, this, Text.SERVERINFO, Util.info(Text.CONSOLE, "Server"));
        this.commands = new StringList();
        boolean daemon = false;
        block10: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(arg.string());
                        continue block10;
                    }
                    case 'd': {
                        this.context.mprop.set(MainProp.DEBUG, true);
                        continue block10;
                    }
                    case 'D': {
                        daemon = true;
                        continue block10;
                    }
                    case 'e': {
                        this.context.mprop.set(MainProp.EVENTPORT, arg.number());
                        continue block10;
                    }
                    case 'i': {
                        this.console = true;
                        continue block10;
                    }
                    case 'p': {
                        this.context.mprop.set(MainProp.SERVERPORT, arg.number());
                        continue block10;
                    }
                    case 'S': {
                        this.service = !daemon;
                        continue block10;
                    }
                    case 'z': {
                        this.quiet = true;
                        continue block10;
                    }
                }
                arg.usage();
                continue;
            }
            if (arg.string().equalsIgnoreCase("stop")) {
                this.stopped = true;
                continue;
            }
            arg.usage();
        }
    }

    public void stop() throws IOException {
        int port = this.context.mprop.num(MainProp.SERVERPORT);
        int eport = this.context.mprop.num(MainProp.EVENTPORT);
        BaseXServer.stop(port, eport);
    }

    public static void start(int port, String ... args) throws BaseXException {
        if (BaseXServer.ping("localhost", port)) {
            throw new BaseXException(Text.SRV_RUNNING, new Object[0]);
        }
        Util.start(BaseXServer.class, args);
        for (int c = 0; c < 10; ++c) {
            if (BaseXServer.ping("localhost", port)) {
                return;
            }
            Performance.sleep(100L);
        }
        throw new BaseXException(Text.CONNECTION_ERROR, new Object[0]);
    }

    public static boolean ping(String host, int port) {
        try {
            new ClientSession(host, port, "", "");
            return false;
        }
        catch (IOException ex) {
            return ex instanceof LoginException;
        }
    }

    public static void stop(int port, int eport) throws IOException {
        IOFile stop = BaseXServer.stopFile(port);
        try {
            stop.touch();
            new Socket("localhost", eport).close();
            new Socket("localhost", port).close();
            while (BaseXServer.ping("localhost", port)) {
                Performance.sleep(50L);
            }
            Performance.sleep(50L);
        }
        catch (IOException ex) {
            stop.delete();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int block(byte[] client) {
        TokenIntMap tokenIntMap = this.blocked;
        synchronized (tokenIntMap) {
            int delay = this.blocked.value(client);
            delay = delay == -1 ? 1 : Math.min(delay, 1024) * 2;
            this.blocked.add(client, delay);
            return delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(byte[] client) {
        TokenIntMap tokenIntMap = this.blocked;
        synchronized (tokenIntMap) {
            this.blocked.delete(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ClientListener client) {
        HashSet<ClientListener> hashSet = this.auth;
        synchronized (hashSet) {
            this.auth.remove(client);
            client.auth.cancel();
        }
    }

    public void initEvents() {
        if (this.events == null) {
            this.events = new EventListener();
            this.events.start();
        }
    }

    final class EventListener
    extends Thread {
        EventListener() {
        }

        @Override
        public void run() {
            block2: while (BaseXServer.this.running) {
                try {
                    Socket es = BaseXServer.this.esocket.accept();
                    if (BaseXServer.this.stop.exists()) {
                        BaseXServer.this.esocket.close();
                        break;
                    }
                    BufferInput bi = new BufferInput(es.getInputStream());
                    long id = Token.toLong(bi.readString());
                    for (ClientListener s : BaseXServer.this.context.sessions) {
                        if (s.getId() != id) continue;
                        s.register(es);
                        continue block2;
                    }
                }
                catch (IOException ex) {
                    break;
                }
            }
        }
    }
}

