/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.core.cmd.AUser;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.server.ClientListener;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DropUser
extends AUser {
    public DropUser(String name) {
        this(name, (String)null);
    }

    public DropUser(String name, String db) {
        super(name, db);
    }

    @Override
    protected boolean run() {
        return this.run(0, true);
    }

    @Override
    protected boolean run(String user, String db) {
        Data data;
        if (user.equals("admin")) {
            return !this.info(Text.ADMIN_STATIC_X, new Object[0]);
        }
        if (db == null) {
            for (ClientListener s : this.context.sessions) {
                if (!s.context().user.name.equals(user)) continue;
                return !this.info(Text.USER_LOGGED_IN_X, user);
            }
            this.context.users.drop(this.context.users.get(user));
            return this.info(Text.USER_DROPPED_X, user);
        }
        try {
            data = Open.open(db, this.context);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return !this.info(msg.isEmpty() ? Text.DB_NOT_OPENED_X : msg, db);
        }
        if (!data.startUpdate()) {
            return !this.info(Text.DB_PINNED_X, data.meta.name);
        }
        if (data.meta.users.drop(data.meta.users.get(user))) {
            this.info(Text.USER_DROPPED_X_X, user, db);
            data.meta.dirty = true;
        }
        data.finishUpdate();
        Close.close(data, this.context);
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        return this.databases(db, 1);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.USER)).arg(0).arg("ON", 1);
    }
}

