/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class Rename
extends ACreate {
    public Rename(String source, String target) {
        super(Perm.WRITE, true, source, target);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        String src = MetaData.normPath(this.args[0]);
        if (src == null) {
            return this.error(Text.NAME_INVALID_X, this.args[0]);
        }
        String trg = MetaData.normPath(this.args[1]);
        if (trg == null) {
            return this.error(Text.NAME_INVALID_X, this.args[1]);
        }
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        boolean ok = true;
        int c = 0;
        IntList docs = data.resources.docs(src);
        int ds = docs.size();
        for (int i = 0; i < ds; ++i) {
            int pre = docs.get(i);
            String target = Rename.target(data, pre, src, trg);
            if (target.isEmpty()) {
                ok = !this.info(Text.NAME_INVALID_X, target);
                continue;
            }
            data.update(pre, 0, Token.token(target));
            ++c;
        }
        IOFile file = data.meta.binary(src);
        if (file != null && file.exists()) {
            IOFile target = data.meta.binary(trg);
            IOFile trgdir = new IOFile(target.dir());
            if (!trgdir.exists() && !trgdir.md() || !file.rename(target)) {
                ok = !this.info(Text.NAME_INVALID_X, trg);
            }
            ++c;
        }
        data.finishUpdate();
        return this.info(Text.RES_RENAMED_X_X, c, this.perf) && ok;
    }

    public static String target(Data data, int pre, String src, String trg) {
        String path = Token.string(data.text(pre, true));
        if (Prop.WIN ? path.equalsIgnoreCase(src) : path.equals(src)) {
            return trg;
        }
        String name = path.substring(src.length() + 1);
        return !trg.isEmpty() ? trg + '/' + name : name;
    }
}

