/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.util.Token;

public class BaseXButton
extends JButton {
    public BaseXButton(String l, Window win) {
        super(l);
        BaseXLayout.addInteraction(this, win);
        if (!(win instanceof BaseXDialog)) {
            return;
        }
        final BaseXDialog d = (BaseXDialog)win;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = BaseXButton.this.getText();
                if (text.equals(Text.B_CANCEL)) {
                    d.cancel();
                } else if (text.equals(Text.B_OK)) {
                    d.close();
                } else {
                    d.action(e.getSource());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    d.cancel();
                }
            }
        });
        BaseXButton.setMnemonic(this, d.mnem);
    }

    public BaseXButton(Window gui, String img, byte[] hlp) {
        super(BaseXLayout.icon(img));
        BaseXLayout.addInteraction(this, gui);
        if (hlp != null) {
            this.setToolTipText(Token.string(hlp));
        }
        Insets in = this.getMargin();
        in.left /= 4;
        in.right /= 4;
        if (in.top < in.left) {
            this.setMargin(in);
        }
    }

    public BaseXButton border(int t, int l, int b, int r) {
        this.setBorder(new EmptyBorder(t, l, b, r));
        return this;
    }

    public static BaseXButton command(final GUICommand cmd, final GUI gui) {
        BaseXButton button = new BaseXButton(gui, cmd.toString().toLowerCase(Locale.ENGLISH), Token.token(cmd.help()));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cmd.execute(gui);
            }
        });
        return button;
    }

    public static void setMnemonic(AbstractButton b, StringBuilder mnem) {
        if (Prop.MAC) {
            return;
        }
        String label = b.getText();
        for (int l = 0; l < label.length(); ++l) {
            char ch = Character.toLowerCase(label.charAt(l));
            if (!Token.letter(ch) || mnem.indexOf(Character.toString(ch)) != -1) continue;
            b.setMnemonic(ch);
            mnem.append(ch);
            break;
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag != this.isEnabled()) {
            super.setEnabled(flag);
        }
    }
}

