/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.query.NumericRange;
import org.basex.index.query.StringRange;
import org.basex.index.stats.IndexStats;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public class DiskValues
implements Index {
    protected final DataAccess idxr;
    protected final DataAccess idxl;
    protected final boolean text;
    protected final Data data;
    protected final IndexCache cache = new IndexCache();
    protected final IntMap<byte[]> ctext = new IntMap();
    protected volatile int size;

    public DiskValues(Data d, boolean txt) throws IOException {
        this(d, txt, txt ? "txt" : "atv");
    }

    protected DiskValues(Data d, boolean txt, String pref) throws IOException {
        this.data = d;
        this.text = txt;
        this.idxl = new DataAccess(d.meta.dbfile(pref + 'l'));
        this.idxr = new DataAccess(d.meta.dbfile(pref + 'r'));
        this.size = this.idxl.read4();
    }

    @Override
    public synchronized void init() {
    }

    @Override
    public synchronized byte[] info() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Sorted List" + Text.NL);
        long l = this.idxl.length() + this.idxr.length();
        tb.add("- Size: " + Performance.format(l, true) + Text.NL);
        IndexStats stats = new IndexStats(this.data);
        for (int m = 0; m < this.size; ++m) {
            long pos = this.idxr.read5((long)m * 5L);
            int oc = this.idxl.readNum(pos);
            if (!stats.adding(oc)) continue;
            stats.add(this.data.text(this.pre(this.idxl.readNum()), this.text));
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public synchronized int count(IndexToken it) {
        if (it instanceof StringRange) {
            return this.idRange((StringRange)it).size();
        }
        if (it instanceof NumericRange) {
            return this.idRange((NumericRange)it).size();
        }
        byte[] key = it.get();
        if (key.length > this.data.meta.maxlen) {
            return Integer.MAX_VALUE;
        }
        return this.entry((byte[])key).size;
    }

    @Override
    public synchronized IndexIterator iter(IndexToken it) {
        if (it instanceof StringRange) {
            return this.idRange((StringRange)it);
        }
        if (it instanceof NumericRange) {
            return this.idRange((NumericRange)it);
        }
        IndexEntry e = this.entry(it.get());
        return this.iter(e.size, e.pointer);
    }

    private IndexEntry entry(byte[] tok) {
        IndexEntry e = this.cache.get(tok);
        if (e != null) {
            return e;
        }
        long p = this.get(tok);
        if (p < 0L) {
            return new IndexEntry(tok, 0, 0L);
        }
        long pos = this.idxr.read5(p * 5L);
        return this.cache.add(tok, this.idxl.readNum(pos), this.idxl.cursor());
    }

    @Override
    public EntryIterator entries(final IndexEntries entries) {
        final byte[] prefix = entries.get();
        final int i = this.get(prefix);
        return new EntryIterator(){
            int ix;
            int nr;
            {
                this.ix = (i >= 0 ? i : (entries.prefix ? -i - 1 : (entries.descending ? -i - 2 : -i - 1))) + (entries.descending ? 1 : -1);
            }

            @Override
            public synchronized byte[] next() {
                if (!(entries.descending ? --this.ix < 0 : ++this.ix == DiskValues.this.size)) {
                    long pos = DiskValues.this.idxr.read5((long)this.ix * 5L);
                    this.nr = DiskValues.this.idxl.readNum(pos);
                    byte[] key = DiskValues.this.data.text(DiskValues.this.pre(DiskValues.this.idxl.readNum()), DiskValues.this.text);
                    if (!entries.prefix || Token.startsWith(key, prefix)) {
                        if (prefix.length != 0) {
                            DiskValues.this.cache.add(key, this.nr, pos + (long)Num.length(this.nr));
                        }
                        return key;
                    }
                }
                return null;
            }

            @Override
            public int count() {
                return this.nr;
            }
        };
    }

    private IndexIterator iter(int s, long ps) {
        IntList pres = new IntList(s);
        long p = ps;
        int id = 0;
        for (int i = 0; i < s; ++i) {
            p = this.idxl.cursor();
            pres.add(this.pre(id += this.idxl.readNum(p)));
        }
        return DiskValues.iter(pres.sort());
    }

    private IndexIterator idRange(StringRange tok) {
        int l;
        IntList pres = new IntList();
        int i = this.get(tok.min);
        int n = i < 0 ? -i - 1 : (l = tok.mni ? i : i + 1);
        while (l < this.size) {
            int ps = this.idxl.readNum(this.idxr.read5((long)l * 5L));
            int id = this.idxl.readNum();
            int pre = this.pre(id);
            int d = Token.diff(this.data.text(pre, this.text), tok.max);
            if (d > 0 || !tok.mxi && d == 0) break;
            for (int p = 0; p < ps; ++p) {
                pres.add(this.pre(id));
                id += this.idxl.readNum();
            }
            ++l;
        }
        return DiskValues.iter(pres.sort());
    }

    protected final IndexIterator idRange(NumericRange tok) {
        double min = tok.min;
        double max = tok.max;
        int len = max > 0.0 && (double)((long)max) == max ? Token.token(max).length : 0;
        boolean simple = len != 0 && min > 0.0 && (double)((long)min) == min && Token.token(min).length == len;
        IntList pres = new IntList();
        for (int l = 0; l < this.size; ++l) {
            int ds = this.idxl.readNum(this.idxr.read5((long)l * 5L));
            int id = this.idxl.readNum();
            int pre = this.pre(id);
            double v = this.data.textDbl(pre, this.text);
            if (v >= min && v <= max) {
                for (int d = 0; d < ds; ++d) {
                    pres.add(this.pre(id));
                    id += this.idxl.readNum();
                }
                continue;
            }
            if (simple && v > max && this.data.textLen(pre, this.text) == len) break;
        }
        return DiskValues.iter(pres.sort());
    }

    protected static IndexIterator iter(final IntList ids) {
        return new IndexIterator(){
            final int s;
            int p;
            {
                this.s = ids.size();
                this.p = -1;
            }

            @Override
            public boolean more() {
                return ++this.p < this.s;
            }

            @Override
            public int next() {
                return ids.get(this.p);
            }

            @Override
            public int size() {
                return this.s;
            }
        };
    }

    protected int pre(int id) {
        return id;
    }

    protected int get(byte[] key) {
        return this.get(key, 0, this.size - 1);
    }

    protected int get(byte[] key, int first, int last) {
        int l = first;
        int h = last;
        while (l <= h) {
            int d;
            int m = l + h >>> 1;
            byte[] txt = this.ctext.get(m);
            if (txt == null) {
                long pos = this.idxr.read5((long)m * 5L);
                this.idxl.readNum(pos);
                txt = this.data.text(this.pre(this.idxl.readNum()), this.text);
                this.ctext.add(m, txt);
            }
            if ((d = Token.diff(txt, key)) == 0) {
                return m;
            }
            if (d < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return -(l + 1);
    }

    public void flush() {
        this.idxl.flush();
        this.idxr.flush();
    }

    @Override
    public synchronized void close() {
        this.flush();
        this.idxl.close();
        this.idxr.close();
    }

    public void index(TokenObjMap<IntList> m) {
    }

    public void delete(TokenObjMap<IntList> m) {
    }

    public void replace(byte[] o, byte[] n, int id) {
    }
}

