/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class FNNode
extends StandardFunc {
    public FNNode(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = (this.expr.length != 0 ? this.expr[0] : this.checkCtx(ctx)).item(ctx, this.info);
        switch (this.sig) {
            case NODE_NAME: {
                QNm qname = it != null ? this.checkNode(it).qname() : null;
                return qname != null && qname.string().length != 0 ? qname : null;
            }
            case DOCUMENT_URI: {
                if (it == null) {
                    return null;
                }
                ANode node = this.checkNode(it);
                if (node.type != NodeType.DOC) {
                    return null;
                }
                byte[] uri = node.baseURI();
                return uri.length == 0 ? null : Uri.uri(uri, false);
            }
            case NILLED: {
                return it == null || this.checkNode((Item)it).type != NodeType.ELM ? null : Bln.FALSE;
            }
            case BASE_URI: {
                if (it == null) {
                    return null;
                }
                ANode n = this.checkNode(it);
                if (n.type != NodeType.ELM && n.type != NodeType.DOC && n.parent() == null) {
                    return null;
                }
                Uri base = Uri.EMPTY;
                do {
                    if (n == null) {
                        return ctx.sc.baseURI().resolve(base);
                    }
                    base = Uri.uri(n.baseURI(), false).resolve(base);
                    if (n.type == NodeType.DOC && n instanceof DBNode) {
                        return base;
                    }
                    n = n.parent();
                } while (!base.isAbsolute());
                return base;
            }
            case NAME: {
                QNm qname = it != null ? this.checkNode(it).qname() : null;
                return qname != null ? Str.get(qname.string()) : Str.ZERO;
            }
            case LOCAL_NAME: {
                QNm qname = it != null ? this.checkNode(it).qname() : null;
                return qname != null ? Str.get(qname.local()) : Str.ZERO;
            }
            case NAMESPACE_URI: {
                QNm qname = it != null ? this.checkNode(it).qname() : null;
                return qname != null ? Uri.uri(qname.uri(), false) : Uri.EMPTY;
            }
            case ROOT: {
                if (it == null) {
                    return null;
                }
                ANode n = this.checkNode(it);
                while (n.parent() != null) {
                    n = n.parent();
                }
                return n;
            }
            case GENERATE_ID: {
                return it == null ? Str.ZERO : Str.get(new TokenBuilder(QueryText.ID).addLong(this.checkNode((Item)it).id).finish());
            }
            case HAS_CHILDREN: {
                return Bln.get(it != null && this.checkNode(it).hasChildren());
            }
            case PATH: {
                return it != null ? this.path(it) : null;
            }
        }
        return super.item(ctx, ii);
    }

    private Str path(Item it) throws QueryException {
        TokenList tl = new TokenList();
        ANode n = this.checkNode(it);
        while (n.parent() != null) {
            ANode fs;
            AxisIter ai;
            QNm qnm;
            int i = 1;
            TokenBuilder tb = new TokenBuilder();
            if (n.type == NodeType.ATT) {
                tb.add(64);
                qnm = n.qname();
                byte[] uri = qnm.uri();
                if (uri.length != 0) {
                    tb.add("Q{").add(qnm.uri()).add(125);
                }
                tb.add(qnm.local());
            } else if (n.type == NodeType.ELM) {
                qnm = n.qname();
                ai = n.precedingSibling();
                while ((fs = ai.next()) != null) {
                    QNm q = fs.qname();
                    if (q == null || !q.eq(qnm)) continue;
                    ++i;
                }
                tb.add("Q{").add(qnm.uri()).add(125).add(qnm.local());
                tb.add(91).add(Integer.toString(i)).add(93);
            } else if (n.type == NodeType.COM || n.type == NodeType.TXT) {
                ANode fs2;
                AxisIter ai2 = n.precedingSibling();
                while ((fs2 = ai2.next()) != null) {
                    if (fs2.type != n.type) continue;
                    ++i;
                }
                tb.addExt(n.type() + "[%]", i);
            } else if (n.type == NodeType.PI) {
                qnm = n.qname();
                ai = n.precedingSibling();
                while ((fs = ai.next()) != null) {
                    if (fs.type != n.type || !fs.qname().eq(qnm)) continue;
                    ++i;
                }
                tb.add(n.type.string()).add("(\"").add(qnm.local());
                tb.add("\")[").add(Integer.toString(i)).add(93);
            }
            tl.add(tb.finish());
            n = n.parent();
        }
        if (n.type != NodeType.DOC) {
            Err.IDDOC.thrw(this.info, new Object[0]);
        }
        TokenBuilder tb = new TokenBuilder();
        for (int i = tl.size() - 1; i >= 0; --i) {
            tb.add(47).add(tl.get(i));
        }
        return Str.get(tb.isEmpty() ? Token.SLASH : tb.finish());
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && (FNNode.oneOf(this.sig, Function.GENERATE_ID, Function.PATH, Function.HAS_CHILDREN) || this.expr.length == 0 && FNNode.oneOf(this.sig, Function.DOCUMENT_URI, Function.NODE_NAME)) || u == Expr.Use.CTX && this.expr.length == 0 || super.uses(u);
    }
}

