/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.basex.build.Parser;
import org.basex.build.file.HTMLParser;
import org.basex.core.Prop;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.io.in.NewlineInput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ByteList;
import org.basex.util.list.StringList;

public final class FNZip
extends StandardFunc {
    private static final QNm Q_FILE = new QNm("zip:file", QueryText.ZIPURI);
    private static final QNm Q_DIR = new QNm("zip:dir", QueryText.ZIPURI);
    private static final QNm Q_ENTRY = new QNm("zip:entry", QueryText.ZIPURI);
    private static final QNm Q_HREF = new QNm("href");
    private static final QNm Q_NAME = new QNm("name");
    private static final QNm Q_SRC = new QNm("src");
    private static final QNm Q_METHOD = new QNm("method");
    private static final String M_BASE64 = "base64";
    private static final String M_HEX = "hex";

    public FNZip(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _ZIP_BINARY_ENTRY: {
                return this.binaryEntry(ctx);
            }
            case _ZIP_TEXT_ENTRY: {
                return this.textEntry(ctx);
            }
            case _ZIP_HTML_ENTRY: {
                return this.xmlEntry(ctx, true);
            }
            case _ZIP_XML_ENTRY: {
                return this.xmlEntry(ctx, false);
            }
            case _ZIP_ENTRIES: {
                return this.entries(ctx);
            }
            case _ZIP_ZIP_FILE: {
                return this.zipFile(ctx);
            }
            case _ZIP_UPDATE_ENTRIES: {
                return this.updateEntries(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private B64 binaryEntry(QueryContext ctx) throws QueryException {
        return new B64(this.entry(ctx));
    }

    private Str textEntry(QueryContext ctx) throws QueryException {
        String enc = this.expr.length < 3 ? null : Token.string(this.checkStr(this.expr[2], ctx));
        IOContent io = new IOContent(this.entry(ctx));
        try {
            return Str.get(new NewlineInput(io).encoding(enc).valid(true).content());
        }
        catch (IOException ex) {
            throw Err.ZIP_FAIL.thrw(this.info, ex);
        }
    }

    private ANode xmlEntry(QueryContext ctx, boolean html) throws QueryException {
        Prop prop = ctx.context.prop;
        IOContent io = new IOContent(this.entry(ctx));
        try {
            return new DBNode(html ? new HTMLParser(io, prop) : Parser.xmlParser(io, prop));
        }
        catch (IOException ex) {
            throw Err.SAXERR.thrw(this.info, ex);
        }
    }

    private ANode entries(QueryContext ctx) throws QueryException {
        String file = Token.string(this.checkStr(this.expr[0], ctx));
        IOFile path = new IOFile(file);
        if (!path.exists()) {
            Err.ZIP_NOTFOUND.thrw(this.info, file);
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            FElem root = new FElem(Q_FILE, new Atts(QueryText.ZIP, QueryText.ZIPURI));
            root.add(Q_HREF, Token.token(path.path()));
            FNZip.createEntries(FNZip.paths(zf).iterator(), root, "");
            FElem fElem = root;
            return fElem;
        }
        catch (IOException ex) {
            throw Err.ZIP_FAIL.thrw(this.info, ex);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String createEntries(Iterator<String> it, FElem par, String pref) {
        String path = null;
        boolean curr = false;
        while (curr || it.hasNext()) {
            if (!curr) {
                path = it.next();
                curr = true;
            }
            if (path == null) break;
            if (!path.startsWith(pref)) {
                return path;
            }
            int i = path.lastIndexOf(47);
            String dir = i == -1 ? path : path.substring(0, i);
            String name = path.substring(i + 1);
            if (name.isEmpty()) {
                path = FNZip.createEntries(it, FNZip.createDir(par, dir), dir);
                continue;
            }
            FNZip.createFile(par, name);
            curr = false;
        }
        return null;
    }

    private static FElem createDir(FElem par, String name) {
        FElem e = new FElem(Q_DIR).add(Q_NAME, Token.token(name));
        par.add(e);
        return e;
    }

    private static void createFile(FElem par, String name) {
        par.add(new FElem(Q_ENTRY).add(Q_NAME, Token.token(name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item zipFile(QueryContext ctx) throws QueryException {
        ANode elm = (ANode)this.checkType(this.expr[0].item(ctx, this.info), NodeType.ELM);
        if (!elm.qname().eq(Q_FILE)) {
            Err.ZIP_UNKNOWN.thrw(this.info, elm.qname());
        }
        String file = this.attribute(elm, Q_HREF, true);
        FileOutputStream fos = null;
        boolean ok = true;
        try {
            fos = new FileOutputStream(file);
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));
            this.create(zos, elm.children(), "", null, ctx);
            zos.close();
        }
        catch (IOException ex) {
            ok = false;
            Err.ZIP_FAIL.thrw(this.info, ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {}
                if (!ok) {
                    new IOFile(file).delete();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(ZipOutputStream zos, AxisIter ai, String root, ZipFile zf, QueryContext ctx) throws QueryException, IOException {
        ANode node;
        byte[] data = new byte[4096];
        while ((node = ai.next()) != null) {
            QNm mode = node.qname();
            boolean dir = mode.eq(Q_DIR);
            if (!dir && !mode.eq(Q_ENTRY)) {
                Err.ZIP_UNKNOWN.thrw(this.info, mode);
            }
            String name = this.attribute(node, Q_NAME, false);
            String src = this.attribute(node, Q_SRC, false);
            if (src != null) {
                src = src.replaceAll("\\\\", "/");
            }
            if (name == null) {
                if (src == null) {
                    throw Err.ZIP_INVALID.thrw(this.info, node.qname(), Q_SRC);
                }
                name = src;
            }
            name = name.replaceAll(".*/", "");
            if (dir) {
                name = name + '/';
            }
            zos.putNextEntry(new ZipEntry(root + name));
            if (dir) {
                this.create(zos, node.children(), root + name, zf, ctx);
                continue;
            }
            if (src != null) {
                if (!new IOFile(src).exists()) {
                    Err.ZIP_NOTFOUND.thrw(this.info, src);
                }
                BufferedInputStream bis = null;
                try {
                    int c;
                    bis = new BufferedInputStream(new FileInputStream(src));
                    while ((c = bis.read(data)) != -1) {
                        zos.write(data, 0, c);
                    }
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            AxisMoreIter ch = node.children();
            String m = this.attribute(node, Q_METHOD, false);
            ANode n = ch.next();
            ZipEntry ze = null;
            if (zf != null && n == null) {
                ze = zf.getEntry(root + name);
            }
            if (ze != null) {
                int c;
                InputStream zis = zf.getInputStream(ze);
                while ((c = zis.read(data)) != -1) {
                    zos.write(data, 0, c);
                }
            } else if (n != null) {
                boolean hex = M_HEX.equals(m);
                if (hex || M_BASE64.equals(m)) {
                    ByteList bl = new ByteList();
                    do {
                        bl.add(n.string());
                    } while ((n = ch.next()) != null);
                    byte[] bytes = bl.toArray();
                    zos.write((hex ? new Hex(bytes) : new B64(bytes)).toJava());
                } else {
                    try {
                        Serializer ser = Serializer.get(zos, FNZip.serPar(node));
                        do {
                            ser.serialize(DataBuilder.stripNS(n, QueryText.ZIPURI, ctx.context));
                        } while ((n = ch.next()) != null);
                        ser.close();
                    }
                    catch (SerializerException ex) {
                        throw ex.getCause(this.info);
                    }
                }
            }
            zos.closeEntry();
        }
    }

    private static SerializerProp serPar(ANode node) {
        ANode at;
        TokenBuilder tb = new TokenBuilder();
        AxisMoreIter ati = node.attributes();
        while ((at = ati.next()) != null) {
            QNm name = at.qname();
            if (name.eq(Q_NAME) || name.eq(Q_SRC)) continue;
            if (!tb.isEmpty()) {
                tb.add(44);
            }
            tb.add(name.local()).add(61).add(at.string());
        }
        return new SerializerProp(tb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item updateEntries(QueryContext ctx) throws QueryException {
        IOFile out;
        ANode elm = (ANode)this.checkType(this.expr[0].item(ctx, this.info), NodeType.ELM);
        if (!elm.qname().eq(Q_FILE)) {
            Err.ZIP_UNKNOWN.thrw(this.info, elm.qname());
        }
        String in = this.attribute(elm, Q_HREF, true);
        IOFile target = new IOFile(Token.string(this.checkStr(this.expr[1], ctx)));
        while ((out = new IOFile(target.path() + new Random().nextInt(Integer.MAX_VALUE))).exists()) {
        }
        if (!new IOFile(in).exists()) {
            Err.ZIP_NOTFOUND.thrw(this.info, in);
        }
        ZipFile zf = null;
        boolean ok = true;
        try {
            zf = new ZipFile(in);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(out.path());
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));
                this.create(zos, elm.children(), "", zf, ctx);
                zos.close();
            }
            catch (IOException ex) {
                ok = false;
                Err.ZIP_FAIL.thrw(this.info, ex);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (IOException ex) {
            throw Err.ZIP_FAIL.thrw(this.info, ex);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {}
            }
            if (ok) {
                target.delete();
                out.rename(target);
            } else {
                out.delete();
            }
        }
        return null;
    }

    private static StringList paths(ZipFile zf) {
        TreeSet<String> paths = new TreeSet<String>();
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            String name = ze.getName();
            int i = name.lastIndexOf(47);
            if (i > -1 && i + 1 < name.length()) {
                paths.add(name.substring(0, i + 1));
            }
            paths.add(name);
        }
        StringList sl = new StringList();
        for (String path : paths) {
            sl.add(path);
        }
        return sl;
    }

    private String attribute(ANode elm, QNm name, boolean force) throws QueryException {
        byte[] val = elm.attribute(name);
        if (val == null && force) {
            throw Err.ZIP_INVALID.thrw(this.info, elm.qname(), name);
        }
        return val == null ? null : Token.string(val);
    }

    private byte[] entry(QueryContext ctx) throws QueryException {
        IOFile file = new IOFile(Token.string(this.checkStr(this.expr[0], ctx)));
        String path = Token.string(this.checkStr(this.expr[1], ctx));
        if (!file.exists()) {
            Err.ZIP_NOTFOUND.thrw(this.info, file);
        }
        try {
            return new Zip(file).read(path);
        }
        catch (FileNotFoundException ex) {
            throw Err.ZIP_NOTFOUND.thrw(this.info, file + "/" + path);
        }
        catch (IOException ex) {
            throw Err.ZIP_FAIL.thrw(this.info, ex);
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT || super.uses(u);
    }
}

