/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.BaseFuncCall;
import org.basex.query.func.Functions;
import org.basex.query.func.UserFunc;
import org.basex.query.func.UserFuncCall;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.TypedFunc;
import org.basex.query.util.Var;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Levenshtein;
import org.basex.util.Token;

public final class UserFuncs
extends ExprInfo {
    private UserFunc[] funcs = new UserFunc[0];
    private UserFuncCall[][] calls = new UserFuncCall[0][];

    TypedFunc get(QNm name, Expr[] args, InputInfo ii) {
        int id = this.indexOf(name, args);
        if (id == -1) {
            return null;
        }
        UserFuncCall call = this.add(ii, this.funcs[id].name, id, args);
        FuncType type = FuncType.get(this.funcs[id]);
        return new TypedFunc(call, type);
    }

    TypedFunc add(QNm name, Expr[] args, InputInfo ii) throws QueryException {
        int al = args.length;
        UserFunc uf = new UserFunc(ii, name, new Var[al], null, null, false);
        UserFuncCall call = this.add(ii, name, this.add(uf, ii), args);
        FuncType type = FuncType.arity(al);
        return new TypedFunc(call, type);
    }

    private int indexOf(QNm name, Expr[] args) {
        for (int id = 0; id < this.funcs.length; ++id) {
            if (!name.eq(this.funcs[id].name) || args.length != this.funcs[id].args.length) continue;
            return id;
        }
        return -1;
    }

    public UserFunc[] funcs() {
        return this.funcs;
    }

    private UserFuncCall add(InputInfo ii, QNm nm, int id, Expr[] arg) {
        BaseFuncCall call = new BaseFuncCall(ii, nm, arg);
        if (this.funcs[id].declared) {
            call.init(this.funcs[id]);
        }
        this.calls[id] = Array.add(this.calls[id], call);
        return call;
    }

    public int add(UserFunc fun, InputInfo ii) throws QueryException {
        QNm name = fun.name;
        byte[] uri = name.uri();
        if (uri.length == 0) {
            Err.FUNNONS.thrw(ii, new Object[]{name.string()});
        }
        if (NSGlobal.reserved(uri)) {
            if (fun.declared) {
                Err.NAMERES.thrw(ii, new Object[]{name.string()});
            }
            this.funError(name, ii);
        }
        byte[] ln = name.local();
        for (int l = 0; l < this.funcs.length; ++l) {
            QNm qn = this.funcs[l].name;
            byte[] u = qn.uri();
            byte[] nm = qn.local();
            if (!Token.eq(ln, nm) || !Token.eq(uri, u) || fun.args.length != this.funcs[l].args.length) continue;
            if (!this.funcs[l].declared) {
                this.funcs[l] = fun;
                return l;
            }
            Err.FUNCDEFINED.thrw(ii, new Object[]{fun.name.string()});
        }
        this.funcs = Array.add(this.funcs, fun);
        this.calls = Array.add(this.calls, new UserFuncCall[0]);
        return this.funcs.length - 1;
    }

    public void check() throws QueryException {
        for (int i = 0; i < this.funcs.length; ++i) {
            for (UserFuncCall c : this.calls[i]) {
                c.init(this.funcs[i]);
            }
        }
        for (UserFunc f : this.funcs) {
            if (f.expr == null) {
                Err.EXTERNALFUNC.thrw(f.info, new Object[]{f.name.string()});
            }
            if (f.declared) continue;
            for (UserFunc uf : this.funcs) {
                if (f == uf || !f.name.eq(uf.name)) continue;
                Err.FUNCTYPE.thrw(f.info, new Object[]{uf.name.string()});
            }
            Err.FUNCUNKNOWN.thrw(f.info, new Object[]{f.name.string()});
        }
    }

    public void checkUp() throws QueryException {
        for (UserFunc f : this.funcs) {
            f.checkUp();
        }
    }

    public void compile(QueryContext ctx) throws QueryException {
        for (int i = 0; i < this.funcs.length; ++i) {
            if (this.calls[i].length == 0) continue;
            this.funcs[i].compile(ctx);
        }
    }

    public void funError(QNm name, InputInfo ii) throws QueryException {
        Functions.get().error(name, ii);
        Levenshtein ls = new Levenshtein();
        byte[] nm = Token.lc(name.local());
        for (UserFunc f : this.funcs) {
            if (!ls.similar(nm, Token.lc(f.name.local()), 0)) continue;
            Err.FUNSIMILAR.thrw(ii, name.string(), f.name.string());
        }
    }

    @Override
    public void plan(FElem plan) {
        if (this.funcs.length != 0) {
            this.addPlan(plan, this.planElem(new Object[0]), this.funcs);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (UserFunc f : this.funcs) {
            sb.append(f.toString());
        }
        return sb.toString();
    }
}

