/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import nl.mpi.arbil.util.BugCatcherManager;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class SymbolGraphic {
    HashMap<String[], ImageIcon> symbolMapEgo = new HashMap();
    HashMap<String[], ImageIcon> symbolMapAlter = new HashMap();
    HashMap<String[], ImageIcon> symbolMapEgoAttached = new HashMap();
    HashMap<String[], ImageIcon> symbolMapAlterAttached = new HashMap();
    private final SVGDocument svgDocument;

    public SymbolGraphic(SVGDocument svgDocument) {
        this.svgDocument = svgDocument;
    }

    public ImageIcon getSymbolGraphic(String[] symbolNames, boolean isEgo, boolean isAttached) {
        HashMap<String[], ImageIcon> symbolMap = isAttached ? (isEgo ? this.symbolMapEgoAttached : this.symbolMapAlterAttached) : (isEgo ? this.symbolMapEgo : this.symbolMapAlter);
        if (symbolMap.containsKey(symbolNames)) {
            return symbolMap.get(symbolNames);
        }
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGDocument doc = (SVGDocument)impl.createDocument(svgNS, "svg", null);
        Element kinSymbols = this.svgDocument.getElementById("KinSymbols");
        Node newNode = doc.importNode((Node)kinSymbols, true);
        doc.getDocumentElement().appendChild(newNode);
        int symbolSize = 15;
        for (String currentSymbol : symbolNames) {
            Element symbolNode = doc.createElementNS(svgNS, "use");
            symbolNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + currentSymbol);
            if (isEgo) {
                if (isAttached) {
                    symbolNode.setAttribute("stroke", "black");
                    symbolNode.setAttribute("fill", "black");
                } else {
                    symbolNode.setAttribute("stroke", "grey");
                    symbolNode.setAttribute("fill", "grey");
                }
            } else {
                symbolNode.setAttribute("fill", "none");
                if (isAttached) {
                    symbolNode.setAttribute("stroke", "black");
                } else {
                    symbolNode.setAttribute("stroke", "grey");
                }
            }
            symbolNode.setAttribute("stroke-width", "2");
            Element svgRoot = doc.getDocumentElement();
            svgRoot.appendChild(symbolNode);
        }
        ImageIconTranscoder transcoder = new ImageIconTranscoder();
        TranscodingHints hints = new TranscodingHints();
        hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(symbolSize));
        hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(symbolSize));
        transcoder.setTranscodingHints(hints);
        try {
            transcoder.transcode(new TranscoderInput((Document)doc), null);
            BufferedImage bufferedImage = transcoder.getImage();
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            symbolMap.put(symbolNames, imageIcon);
            return imageIcon;
        }
        catch (TranscoderException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            return null;
        }
    }

    class ImageIconTranscoder
    extends ImageTranscoder {
        private BufferedImage image = null;

        ImageIconTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            return this.image;
        }

        public void writeImage(BufferedImage img, TranscoderOutput out) {
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

