/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.flap.module.BaseModule;
import nl.mpi.flap.plugin.KinOathPanelPlugin;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityService;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.ProcessAbortException;
import nl.mpi.kinnate.entityindexer.QueryParser;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.kintypestrings.ImportRequiredException;
import nl.mpi.kinnate.kintypestrings.KinTermCalculator;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.MouseListenerSvg;
import nl.mpi.kinnate.ui.ArchiveEntityLinkerPanel;
import nl.mpi.kinnate.ui.DiagramSettingsPanel;
import nl.mpi.kinnate.ui.EgoSelectionPanel;
import nl.mpi.kinnate.ui.EntitySearchPanel;
import nl.mpi.kinnate.ui.ExportPanel;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTermPanel;
import nl.mpi.kinnate.ui.KinTypeStringInput;
import nl.mpi.kinnate.ui.KinTypeStringProvider;
import nl.mpi.kinnate.ui.MetadataPanel;
import nl.mpi.kinnate.ui.ProjectTreePanel;
import nl.mpi.kinnate.ui.StatusBar;
import nl.mpi.kinnate.ui.TableCellDragHandler;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinDiagramPanel
extends JPanel
implements SavePanel,
KinTermSavePanel,
ArbilDataNodeContainer {
    private ProjectManager projectManager;
    private EntityCollection entityCollection;
    private KinTypeStringInput kinTypeStringInput;
    private ArrayList<KinTypeStringProvider> kinTypeStringProviders;
    private GraphPanel graphPanel;
    private EgoSelectionPanel egoSelectionPanel;
    private ProjectTreePanel projectTree = null;
    private ArchiveEntityLinkerPanel archiveEntityLinkerPanelRemote;
    private ArchiveEntityLinkerPanel archiveEntityLinkerPanelLocal;
    private ArchiveEntityLinkerPanel archiveEntityLinkerPanelMpiRemote;
    private HidePane kinTermHidePane;
    private HidePane kinTypeHidePane;
    private EntityService entityIndex;
    private JProgressBar progressBar;
    private HashMap<ArbilDataNode, UniqueIdentifier> registeredArbilDataNode;
    private HashMap<ArbilNode, Boolean> arbilDataNodesChangedStatus;
    private SessionStorage sessionStorage;
    private ArbilWindowManager dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;
    private ArbilTreeHelper treeHelper;
    private KinDragTransferHandler dragTransferHandler;
    private AbstractDiagramManager diagramWindowManager;
    private StatusBar statusBar;
    private TableCellDragHandler tableCellDragHandler = new TableCellDragHandler();
    boolean graphThreadRunning = false;
    boolean graphUpdateRequired = false;

    public KinDiagramPanel(URI existingFile, boolean savableType, ProjectRecord projectRecord, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, ProjectManager projectManager, AbstractDiagramManager diagramWindowManager) throws EntityServiceException {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
        this.diagramWindowManager = diagramWindowManager;
        this.projectManager = projectManager;
        this.initKinDiagramPanel(existingFile, null, savableType, projectRecord);
    }

    public KinDiagramPanel(DocumentNewMenu.DocumentType documentType, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, ProjectManager projectManager, AbstractDiagramManager diagramWindowManager) throws EntityServiceException {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
        this.diagramWindowManager = diagramWindowManager;
        this.projectManager = projectManager;
        this.initKinDiagramPanel(null, documentType, false, null);
    }

    public KinDiagramPanel(DocumentNewMenu.DocumentType documentType, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, EntityCollection entityCollection, AbstractDiagramManager diagramWindowManager) throws EntityServiceException {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
        this.entityCollection = entityCollection;
        this.diagramWindowManager = diagramWindowManager;
        this.initKinDiagramPanel(null, documentType, false, null);
    }

    private void initKinDiagramPanel(URI existingFile, DocumentNewMenu.DocumentType documentType, boolean savableType, ProjectRecord projectRecord) throws EntityServiceException {
        this.progressBar = new JProgressBar();
        this.graphPanel = new GraphPanel(this, this.dialogHandler, this.sessionStorage, this.dataNodeLoader);
        this.kinTypeStringInput = new KinTypeStringInput(this.graphPanel.dataStoreSvg);
        boolean showKinTerms = false;
        boolean showArchiveLinker = false;
        boolean showDiagramTree = false;
        boolean showEntitySearch = false;
        boolean showIndexerSettings = false;
        boolean showKinTypeStrings = false;
        boolean showExportPanel = false;
        boolean showMetaData = false;
        if (existingFile != null) {
            this.graphPanel.readSvg(existingFile, savableType);
            String kinTermContents = null;
            for (String currentKinTypeString : this.graphPanel.getKinTypeStrigs()) {
                if (currentKinTypeString.trim().length() <= 0) continue;
                kinTermContents = kinTermContents == null ? "" : kinTermContents + "\n";
                kinTermContents = kinTermContents + currentKinTypeString.trim();
            }
            this.kinTypeStringInput.setText(kinTermContents);
        } else {
            this.kinTypeStringInput.setDefaultText();
            if (documentType == null) {
                documentType = DocumentNewMenu.DocumentType.Simple;
            }
            switch (documentType) {
                case ArchiveLinker: {
                    showMetaData = true;
                    showDiagramTree = true;
                    showArchiveLinker = true;
                    this.graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.KinTypeQuery;
                    break;
                }
                case KinTerms: {
                    showKinTerms = true;
                    this.graphPanel.addKinTermGroup();
                    this.graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.FreeForm;
                    break;
                }
                case Freeform: {
                    showKinTypeStrings = true;
                    this.graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.FreeForm;
                    break;
                }
                case Simple: {
                    showMetaData = true;
                    showDiagramTree = true;
                    showEntitySearch = true;
                    this.graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.KinTypeQuery;
                    break;
                }
                case Query: {
                    showMetaData = true;
                    showDiagramTree = true;
                    showKinTypeStrings = true;
                    this.graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.KinTypeQuery;
                }
            }
            this.graphPanel.generateDefaultSvg();
        }
        if (this.entityCollection != null) {
            this.graphPanel.dataStoreSvg.projectRecord = this.entityCollection.getProjectRecord();
        } else {
            if (projectRecord != null) {
                this.graphPanel.dataStoreSvg.projectRecord = projectRecord;
            } else if (this.graphPanel.dataStoreSvg.projectRecord == null) {
                this.graphPanel.dataStoreSvg.projectRecord = this.projectManager.getDefaultProject(this.sessionStorage);
            }
            this.entityCollection = this.projectManager.getEntityCollectionForProject(this.graphPanel.dataStoreSvg.projectRecord);
        }
        this.graphPanel.setEntityCollection(this.entityCollection);
        try {
            this.projectManager.addRecentProjectRecord(this.graphPanel.dataStoreSvg.projectRecord, this);
        }
        catch (JAXBException exception) {
            this.dialogHandler.addMessageDialogToQueue("Failed to save the project in the recent list: " + exception.getMessage(), "Recent Project List Error");
        }
        this.setLayout(new BorderLayout());
        this.progressBar.setVisible(false);
        this.graphPanel.add((Component)this.progressBar, "First");
        this.registeredArbilDataNode = new HashMap();
        this.arbilDataNodesChangedStatus = new HashMap();
        this.egoSelectionPanel = new EgoSelectionPanel(this, this.graphPanel, (MessageDialogHandler)this.dialogHandler, this.entityCollection, this.dataNodeLoader);
        JPanel kinGraphPanel = new JPanel(new BorderLayout());
        this.kinTypeHidePane = new HidePane(HidePane.HidePanePosition.top, 0);
        HidePane tableHidePane = new HidePane(HidePane.HidePanePosition.bottom, 150);
        this.dragTransferHandler = new KinDragTransferHandler(this, this.sessionStorage, this.entityCollection);
        this.graphPanel.setTransferHandler(this.dragTransferHandler);
        this.egoSelectionPanel.setTransferHandler(this.dragTransferHandler);
        if (this.graphPanel.dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.KinTypeQuery) {
            this.projectTree = new ProjectTreePanel(this.entityCollection, this.graphPanel.getSymbolGraphic(), "Project Tree", this, this.graphPanel, (MessageDialogHandler)this.dialogHandler, this.dataNodeLoader);
            this.projectTree.setTransferHandler(this.dragTransferHandler);
        }
        EntitySearchPanel entitySearchPanel = new EntitySearchPanel(this.entityCollection, this, this.graphPanel, (MessageDialogHandler)this.dialogHandler, this.dataNodeLoader);
        entitySearchPanel.setTransferHandler(this.dragTransferHandler);
        HidePane egoSelectionHidePane = new HidePane(HidePane.HidePanePosition.left, 0);
        this.kinTermHidePane = new HidePane(HidePane.HidePanePosition.right, 0);
        this.graphPanel.setArbilTableModel(new MetadataPanel(this.graphPanel, this.entityCollection, this, tableHidePane, this.tableCellDragHandler, this.dataNodeLoader, null, this.sessionStorage, (MessageDialogHandler)this.dialogHandler, null, null));
        block20: for (VisiblePanelSetting.PanelType panelType : VisiblePanelSetting.PanelType.values()) {
            VisiblePanelSetting panelSetting = this.graphPanel.dataStoreSvg.getPanelSettingByType(panelType);
            switch (panelType) {
                case ArchiveLinker: {
                    this.treeHelper.loadLocationsList();
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.ArchiveLinker, 150, showArchiveLinker);
                    }
                    panelSetting.setHidePane(this.kinTermHidePane, "Archive Linker");
                    if (this.treeHelper.getRemoteCorpusNodes().length > 0) {
                        this.archiveEntityLinkerPanelRemote = new ArchiveEntityLinkerPanel(panelSetting, this, this.graphPanel, this.dragTransferHandler, ArchiveEntityLinkerPanel.TreeType.RemoteTree, this.treeHelper, this.dataNodeLoader);
                        panelSetting.addTargetPanel(this.archiveEntityLinkerPanelRemote, false);
                    }
                    if (this.treeHelper.getLocalCorpusNodes().length > 0) {
                        this.archiveEntityLinkerPanelLocal = new ArchiveEntityLinkerPanel(panelSetting, this, this.graphPanel, this.dragTransferHandler, ArchiveEntityLinkerPanel.TreeType.LocalTree, this.treeHelper, this.dataNodeLoader);
                        panelSetting.addTargetPanel(this.archiveEntityLinkerPanelLocal, false);
                    }
                    this.archiveEntityLinkerPanelMpiRemote = new ArchiveEntityLinkerPanel(panelSetting, this, this.graphPanel, this.dragTransferHandler, ArchiveEntityLinkerPanel.TreeType.MpiTree, this.treeHelper, this.dataNodeLoader);
                    panelSetting.addTargetPanel(this.archiveEntityLinkerPanelMpiRemote, false);
                    panelSetting.setMenuEnabled(this.graphPanel.dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.KinTypeQuery);
                    continue block20;
                }
                case DiagramTree: {
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.DiagramTree, 150, showDiagramTree);
                    }
                    panelSetting.setHidePane(egoSelectionHidePane, "Diagram Tree");
                    panelSetting.addTargetPanel(this.egoSelectionPanel, false);
                    if (this.projectTree != null) {
                        panelSetting.addTargetPanel(this.projectTree, true);
                    }
                    panelSetting.setMenuEnabled(true);
                    continue block20;
                }
                case EntitySearch: {
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.EntitySearch, 150, showEntitySearch);
                    }
                    panelSetting.setHidePane(egoSelectionHidePane, "Search Entities");
                    panelSetting.addTargetPanel(entitySearchPanel, false);
                    panelSetting.setMenuEnabled(this.graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm);
                    continue block20;
                }
                case IndexerSettings: {
                    continue block20;
                }
                case KinTerms: {
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.KinTerms, 150, showKinTerms);
                    }
                    panelSetting.setHidePane(this.kinTermHidePane, "Kin Terms");
                    for (KinTermGroup kinTerms : this.graphPanel.getkinTermGroups()) {
                        panelSetting.addTargetPanel(new KinTermPanel(this, kinTerms, (MessageDialogHandler)this.dialogHandler), false);
                    }
                    panelSetting.setMenuEnabled(this.graphPanel.dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.FreeForm);
                    continue block20;
                }
                case KinTypeStrings: {
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.KinTypeStrings, 150, showKinTypeStrings);
                    }
                    panelSetting.setHidePane(this.kinTypeHidePane, "Kin Type Strings");
                    panelSetting.addTargetPanel(new JScrollPane(this.kinTypeStringInput), false);
                    panelSetting.setMenuEnabled(true);
                    continue block20;
                }
                case ExportPanel: {
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.ExportPanel, 150, showExportPanel);
                    }
                    panelSetting.setHidePane(this.kinTypeHidePane, "Export Data");
                    panelSetting.addTargetPanel(new ExportPanel(), false);
                    panelSetting.setMenuEnabled(false);
                    continue block20;
                }
                case PluginPanel: {
                    if (panelSetting == null) {
                        panelSetting = this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.PluginPanel, 150, false);
                    }
                    panelSetting.setHidePane(this.kinTypeHidePane, "Active Plugins");
                    panelSetting.setMenuEnabled(panelSetting.getTargetPanels().length > 0);
                    continue block20;
                }
                default: {
                    this.dialogHandler.addMessageDialogToQueue("Panel type '" + panelType.name() + "' unknown or unsupported.", "Load Diagram");
                }
            }
        }
        tableHidePane.setVisible(false);
        kinGraphPanel.add((Component)this.kinTypeHidePane, "First");
        kinGraphPanel.add((Component)egoSelectionHidePane, "Before");
        kinGraphPanel.add((Component)this.graphPanel, "Center");
        kinGraphPanel.add((Component)this.kinTermHidePane, "After");
        kinGraphPanel.add((Component)tableHidePane, "Last");
        this.add((Component)kinGraphPanel, "Center");
        this.statusBar = new StatusBar("diagram data not yet loaded");
        this.add((Component)this.statusBar, "South");
        EntityData[] svgDataNodes = this.graphPanel.dataStoreSvg.graphData != null ? this.graphPanel.dataStoreSvg.graphData.getDataNodes() : new EntityData[]{};
        this.entityIndex = new QueryParser(this.entityCollection);
        this.kinTypeStringInput.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent e) {
                KeyEvent keyEvent = e;
                synchronized (keyEvent) {
                    KinDiagramPanel.this.redrawIfKinTermsChanged();
                }
            }
        });
        this.kinTypeStringProviders = new ArrayList();
        this.kinTypeStringProviders.add(this.kinTypeStringInput);
        this.kinTypeStringProviders.add(entitySearchPanel);
        this.kinTypeStringProviders.addAll(Arrays.asList(this.graphPanel.getkinTermGroups()));
    }

    public void setStatusBarText(String statusText) {
        this.statusBar.setStatusBarText(statusText);
    }

    public static File getGlobalDefaultDiagramFile(SessionStorage sessionStorage) {
        return new File(sessionStorage.getProjectDirectory(), "DefaultKinDiagram.svg");
    }

    public static File getDefaultDiagramFile(ProjectRecord projectRecord) {
        return new File(projectRecord.getProjectDirectory(), "DefaultKinDiagram.svg");
    }

    public void redrawIfKinTermsChanged() {
        if (this.kinTypeStringInput.hasChanges()) {
            this.graphPanel.setKinTypeStrigs(this.kinTypeStringInput.getCurrentStrings());
            this.drawGraph(false);
        }
    }

    public boolean verifyDiagramDataLoaded() {
        if (this.graphPanel.dataStoreSvg.graphData == null) {
            if (this.dialogHandler.showConfirmDialogBox("The diagram needs to be recalculated before it can be interacted with.\nRecalculate now?", "Recalculate Diagram")) {
                this.drawGraph(true);
            }
            return false;
        }
        return true;
    }

    public synchronized void drawGraph(boolean resetZoom) {
        this.drawGraph(null, resetZoom);
    }

    public synchronized void drawGraph(final UniqueIdentifier[] uniqueIdentifiers, final boolean resetZoom) {
        this.graphUpdateRequired = true;
        this.entityIndex.requestAbortProcess();
        if (!this.graphThreadRunning) {
            this.graphThreadRunning = true;
            new Thread(){

                public void run() {
                    while (KinDiagramPanel.this.graphUpdateRequired) {
                        try {
                            KinDiagramPanel.this.graphUpdateRequired = false;
                            KinDiagramPanel.this.entityIndex.clearAbortRequest();
                            try {
                                String[] kinTypeStrings = KinDiagramPanel.this.graphPanel.getKinTypeStrigs();
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        KinDiagramPanel.this.progressBar.setValue(0);
                                        KinDiagramPanel.this.progressBar.setVisible(true);
                                    }
                                });
                                if (((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.Undefined) {
                                    ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.FreeForm;
                                    if (!((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.egoEntities.isEmpty() || !((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.requiredEntities.isEmpty()) {
                                        ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.KinTypeQuery;
                                    } else {
                                        for (String currentLine : kinTypeStrings) {
                                            if (!currentLine.contains("[")) continue;
                                            ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.diagramMode = DataStoreSvg.DiagramMode.KinTypeQuery;
                                            break;
                                        }
                                    }
                                }
                                if (((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.diagramMode == DataStoreSvg.DiagramMode.KinTypeQuery) {
                                    EntityData[] graphNodes = KinDiagramPanel.this.entityIndex.processKinTypeStrings(KinDiagramPanel.this.kinTypeStringProviders, KinDiagramPanel.this.graphPanel.getIndexParameters(), ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg, KinDiagramPanel.this.progressBar);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            KinDiagramPanel.this.progressBar.setIndeterminate(true);
                                        }
                                    });
                                    if (((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.graphData == null) {
                                        ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.graphData = new GraphSorter();
                                    }
                                    ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.graphData.setEntitys(graphNodes);
                                    KinDiagramPanel.this.graphPanel.drawNodes(((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.graphData, resetZoom);
                                    KinDiagramPanel.this.egoSelectionPanel.setTreeNodes(KinDiagramPanel.this.graphPanel);
                                    new KinTermCalculator().insertKinTerms(((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.graphData.getDataNodes(), KinDiagramPanel.this.graphPanel.getkinTermGroups());
                                    continue;
                                }
                                KinTypeStringConverter graphData = new KinTypeStringConverter(((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg);
                                graphData.readKinTypes(KinDiagramPanel.this.kinTypeStringProviders, ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg);
                                KinDiagramPanel.this.graphPanel.drawNodes(graphData, resetZoom);
                                KinDiagramPanel.this.egoSelectionPanel.setTreeNodes(KinDiagramPanel.this.graphPanel);
                                new KinTermCalculator().insertKinTerms(graphData.getDataNodes(), KinDiagramPanel.this.graphPanel.getkinTermGroups());
                            }
                            catch (EntityServiceException exception) {
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                KinDiagramPanel.this.dialogHandler.addMessageDialogToQueue("Failed to load all entities required", "Draw Graph");
                            }
                        }
                        catch (ProcessAbortException exception) {
                            System.out.println("draw graph process has been aborted, it should be safe to let the next thread loop take over from here");
                        }
                        catch (ImportRequiredException exception) {
                            if (exception.getImportURI() != null) {
                                Object[] optionStrings = new String[]{"Import", "Cancel"};
                                int userOption = KinDiagramPanel.this.dialogHandler.showDialogBox(exception.getMessageString() + "\nDo you want to import this data now?\n" + exception.getImportURI().toASCIIString(), "Import Required", 2, 3, optionStrings, (Object)optionStrings[0]);
                                if (userOption != 0) continue;
                                try {
                                    if ("jar".equals(exception.getImportURI().getScheme())) {
                                        KinDiagramPanel.this.diagramWindowManager.openJarImportPanel(exception.getImportURI().getPath(), KinDiagramPanel.this, KinDiagramPanel.this.entityCollection);
                                        continue;
                                    }
                                    KinDiagramPanel.this.diagramWindowManager.openImportPanel(exception.getImportURI().toASCIIString(), KinDiagramPanel.this, KinDiagramPanel.this.entityCollection);
                                }
                                catch (ImportException exception1) {
                                    KinDiagramPanel.this.dialogHandler.addMessageDialogToQueue(exception1.getMessage() + "\n" + exception.getImportURI().toASCIIString(), "Import Required Data");
                                }
                                continue;
                            }
                            KinDiagramPanel.this.dialogHandler.addMessageDialogToQueue(exception.getMessageString(), "Draw Graph");
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            KinDiagramPanel.this.progressBar.setVisible(false);
                        }
                    });
                    KinDiagramPanel.this.graphThreadRunning = false;
                    if (uniqueIdentifiers != null) {
                        KinDiagramPanel.this.graphPanel.setSelectedIds(uniqueIdentifiers);
                    }
                }
            }.start();
        }
    }

    public void setEgoNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.egoEntities = new HashSet<UniqueIdentifier>(Arrays.asList(egoIdentifierArray));
        this.drawGraph(false);
    }

    public void addEgoNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.egoEntities.addAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph(false);
    }

    public void removeEgoNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.egoEntities.removeAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph(false);
    }

    public void addNodeCollection(UniqueIdentifier[] entityIdentifiers, String nodeSetTitle) {
        EntitySearchPanel entitySearchPanel = new EntitySearchPanel(this.entityCollection, this, this.graphPanel, (MessageDialogHandler)this.dialogHandler, this.dataNodeLoader, nodeSetTitle, entityIdentifiers);
        entitySearchPanel.setTransferHandler(this.dragTransferHandler);
        this.kinTermHidePane.addTab(nodeSetTitle, entitySearchPanel);
        this.kinTermHidePane.setHiddeState();
        this.kinTypeStringProviders.add(entitySearchPanel);
    }

    public void addKinTermGroup() {
        KinTermGroup kinTermGroup = this.graphPanel.addKinTermGroup();
        for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() != VisiblePanelSetting.PanelType.KinTerms) continue;
            panelSetting.addTargetPanel(new KinTermPanel(this, kinTermGroup, (MessageDialogHandler)this.dialogHandler), true);
        }
        this.kinTypeStringProviders.add(kinTermGroup);
    }

    public void addPluginPanel(KinOathPanelPlugin kinOathPanelPlugin, boolean isVisible) throws PluginException {
        VisiblePanelSetting panelSetting = this.graphPanel.dataStoreSvg.getPanelSettingByType(VisiblePanelSetting.PanelType.PluginPanel);
        if (panelSetting != null) {
            JScrollPane uiPanel = kinOathPanelPlugin.getUiPanel((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.sessionStorage, (PluginBugCatcher)BugCatcherManager.getBugCatcher());
            uiPanel.setName("Plugin: " + ((BaseModule)kinOathPanelPlugin).getName());
            if (isVisible) {
                panelSetting.setPanelShown(true);
                panelSetting.addTargetPanel(uiPanel, true);
            } else {
                panelSetting.removeTargetPanel(uiPanel);
            }
            panelSetting.setMenuEnabled(panelSetting.getTargetPanels().length > 0);
        }
    }

    public void addRequiredNodes(UniqueIdentifier[] egoIdentifierArray, Point screenLocation) {
        if (screenLocation != null) {
            Point defaultLocation = this.graphPanel.svgUpdateHandler.getEntityPointOnDocument(screenLocation);
            this.graphPanel.dataStoreSvg.graphData.setPreferredEntityLocation(egoIdentifierArray, defaultLocation);
        }
        this.graphPanel.dataStoreSvg.requiredEntities.addAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph(false);
    }

    public void removeRequiredNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.requiredEntities.removeAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph(false);
    }

    public void loadAllTrees() {
        this.egoSelectionPanel.setTreeNodes(this.graphPanel);
        if (this.archiveEntityLinkerPanelRemote != null) {
            this.archiveEntityLinkerPanelRemote.loadTreeNodes();
        }
        if (this.archiveEntityLinkerPanelLocal != null) {
            this.archiveEntityLinkerPanelLocal.loadTreeNodes();
        }
        if (this.archiveEntityLinkerPanelMpiRemote != null) {
            this.archiveEntityLinkerPanelMpiRemote.loadTreeNodes();
        }
        if (this.projectTree != null) {
            this.projectTree.loadProjectTree();
            this.entityCollection.addDatabaseUpdateListener(this.projectTree);
        }
    }

    public void showProgressBar() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
            this.revalidate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KinDiagramPanel.this.progressBar.setIndeterminate(true);
                    KinDiagramPanel.this.progressBar.setVisible(true);
                    KinDiagramPanel.this.revalidate();
                }
            });
        }
    }

    public void clearProgressBar() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setVisible(false);
            this.revalidate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KinDiagramPanel.this.progressBar.setIndeterminate(false);
                    KinDiagramPanel.this.progressBar.setVisible(false);
                    KinDiagramPanel.this.revalidate();
                }
            });
        }
    }

    public boolean hasSaveFileName() {
        return this.graphPanel.hasSaveFileName();
    }

    public File getFileName() {
        return this.graphPanel.getFileName();
    }

    public boolean requiresSave() {
        return this.graphPanel.requiresSave();
    }

    public void setRequiresSave() {
        this.graphPanel.setRequiresSave();
    }

    public void saveToFile() {
        this.graphPanel.saveToFile();
    }

    public void saveToFile(File saveFile) {
        this.graphPanel.saveToFile(saveFile);
    }

    public void updateGraph() {
        this.drawGraph(true);
    }

    public void doActionCommand(MouseListenerSvg.ActionCode actionCode) {
        this.graphPanel.mouseListenerSvg.performMenuAction(actionCode);
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public void showSettings() {
        this.diagramWindowManager.createDialogueContainer(new DiagramSettingsPanel(this, this.entityCollection, this.sessionStorage, this.graphPanel, this.dialogHandler, this.tableCellDragHandler), this).setVisible(true);
    }

    public void exportKinTerms() {
        Component tabComponent = this.kinTermHidePane.getSelectedComponent();
        if (tabComponent instanceof KinTermPanel) {
            ((KinTermPanel)tabComponent).exportKinTerms();
        }
    }

    public void importKinTerms() {
        Component tabComponent = this.kinTermHidePane.getSelectedComponent();
        if (tabComponent instanceof KinTermPanel) {
            ((KinTermPanel)tabComponent).importKinTerms();
        }
    }

    public EntityCollection getEntityCollection() {
        return this.entityCollection;
    }

    public int getKinTermGroupCount() {
        return this.graphPanel.getkinTermGroups().length;
    }

    public VisiblePanelSetting[] getVisiblePanels() {
        return this.graphPanel.dataStoreSvg.getVisiblePanels();
    }

    public void setPanelState(VisiblePanelSetting.PanelType panelType, boolean panelVisible) {
        for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() != panelType) continue;
            panelSetting.setPanelShown(panelVisible);
        }
    }

    public boolean getPanelState(VisiblePanelSetting.PanelType panelType) {
        for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() != panelType) continue;
            return panelSetting.isPanelShown();
        }
        return false;
    }

    public void setSelectedKinTypeSting(String kinTypeStrings) {
        for (Component tabComponent : this.kinTermHidePane.getComponents()) {
            if (!(tabComponent instanceof KinTermPanel)) continue;
            KinTermPanel kinTermPanel = (KinTermPanel)tabComponent;
            kinTermPanel.setDefaultKinType(kinTypeStrings);
        }
    }

    public EntityData[] getGraphEntities() {
        if (this.graphPanel.dataStoreSvg.graphData == null) {
            return new EntityData[0];
        }
        return this.graphPanel.dataStoreSvg.graphData.getDataNodes();
    }

    public void registerArbilNode(UniqueIdentifier uniqueIdentifier, ArbilDataNode arbilDataNode) {
        if (!this.registeredArbilDataNode.containsKey(arbilDataNode)) {
            arbilDataNode.registerContainer((ArbilDataNodeContainer)this);
            this.registeredArbilDataNode.put(arbilDataNode, uniqueIdentifier);
        }
    }

    public void entityRelationsChanged(UniqueIdentifier[] selectedIdentifiers) {
        this.graphPanel.getIndexParameters().valuesChanged = true;
        this.drawGraph(false);
    }

    public void dataNodeIconCleared(ArbilNode arbilNode) {
        if (this.arbilDataNodesChangedStatus.containsKey(arbilNode)) {
            boolean dataBaseRequiresUpdate = false;
            boolean redrawRequired = false;
            if (arbilNode instanceof ArbilDataNode) {
                ArbilDataNode arbilDataNode = (ArbilDataNode)arbilNode;
                boolean currentlyNeedsSave = arbilDataNode.getNeedsSaveToDisk(false);
                if (currentlyNeedsSave != this.arbilDataNodesChangedStatus.get(arbilNode)) {
                    this.arbilDataNodesChangedStatus.put(arbilNode, currentlyNeedsSave);
                    UniqueIdentifier uniqueIdentifier = this.registeredArbilDataNode.get(arbilDataNode);
                    for (EntityData entityData : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                        if (!entityData.getUniqueIdentifier().equals(uniqueIdentifier)) continue;
                        entityData.metadataRequiresSave = currentlyNeedsSave;
                    }
                    dataBaseRequiresUpdate = !currentlyNeedsSave;
                    redrawRequired = true;
                }
                if (dataBaseRequiresUpdate) {
                    try {
                        this.entityCollection.updateDatabase(arbilDataNode.getURI(), this.registeredArbilDataNode.get(arbilDataNode));
                        this.graphPanel.getIndexParameters().valuesChanged = true;
                    }
                    catch (EntityServiceException exception) {
                        this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Update Database");
                    }
                }
            }
            if (redrawRequired) {
                this.drawGraph(false);
            }
        } else {
            this.arbilDataNodesChangedStatus.put(arbilNode, false);
        }
    }

    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newChildNode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dataNodeRemoved(ArbilNode adn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isFullyLoadedNodeRequired() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

