/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class KinTermsMenu
extends JMenu {
    AbstractDiagramManager diagramWindowManager;
    KinTermSavePanel currentKinTermSavePanel;
    JCheckBoxMenuItem hideShowMenu;
    JMenuItem newMenu;
    JMenuItem exportMenu;
    JMenuItem importMenu;
    JMenuItem deleteMenu;
    private Component parentComponent;

    public KinTermsMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.initMenu();
    }

    public KinTermsMenu() {
        this.initMenu();
    }

    private void initMenu() {
        this.hideShowMenu = new JCheckBoxMenuItem("Show");
        this.newMenu = new JMenuItem("New Kin Term Group");
        this.exportMenu = new JMenuItem("Export");
        this.importMenu = new JMenuItem("Import");
        this.deleteMenu = new JMenuItem("Delete");
        this.setText("Kin Terms");
        this.add(this.hideShowMenu);
        this.add(this.newMenu);
        this.add(this.importMenu);
        this.add(this.exportMenu);
        this.add(this.deleteMenu);
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                KinTermsMenu.this.currentKinTermSavePanel = KinTermsMenu.this.diagramWindowManager.getKinTermPanel(KinTermsMenu.this.parentComponent);
                if (KinTermsMenu.this.currentKinTermSavePanel != null) {
                    VisiblePanelSetting[] visiblePanelsArray;
                    for (VisiblePanelSetting panelSetting : visiblePanelsArray = KinTermsMenu.this.currentKinTermSavePanel.getVisiblePanels()) {
                        if (panelSetting.getPanelType() == null || panelSetting.getPanelType() != VisiblePanelSetting.PanelType.KinTerms || panelSetting.isMenuEnabled()) continue;
                        KinTermsMenu.this.exportMenu.setEnabled(false);
                        KinTermsMenu.this.importMenu.setEnabled(false);
                        KinTermsMenu.this.hideShowMenu.setEnabled(false);
                        KinTermsMenu.this.newMenu.setEnabled(false);
                        KinTermsMenu.this.deleteMenu.setEnabled(false);
                        return;
                    }
                    if (KinTermsMenu.this.currentKinTermSavePanel.getKinTermGroupCount() == 0) {
                        KinTermsMenu.this.hideShowMenu.setSelected(false);
                        KinTermsMenu.this.hideShowMenu.setEnabled(false);
                        KinTermsMenu.this.exportMenu.setEnabled(false);
                        KinTermsMenu.this.importMenu.setEnabled(false);
                        KinTermsMenu.this.newMenu.setEnabled(true);
                        KinTermsMenu.this.deleteMenu.setEnabled(false);
                    } else {
                        KinTermsMenu.this.hideShowMenu.setEnabled(true);
                        if (!KinTermsMenu.this.currentKinTermSavePanel.getPanelState(VisiblePanelSetting.PanelType.KinTerms)) {
                            KinTermsMenu.this.hideShowMenu.setSelected(false);
                            KinTermsMenu.this.exportMenu.setEnabled(false);
                            KinTermsMenu.this.importMenu.setEnabled(false);
                            KinTermsMenu.this.newMenu.setEnabled(false);
                            KinTermsMenu.this.deleteMenu.setEnabled(false);
                        } else {
                            KinTermsMenu.this.hideShowMenu.setSelected(true);
                            KinTermsMenu.this.exportMenu.setEnabled(true);
                            KinTermsMenu.this.importMenu.setEnabled(true);
                            KinTermsMenu.this.newMenu.setEnabled(true);
                            KinTermsMenu.this.deleteMenu.setEnabled(false);
                        }
                    }
                } else {
                    KinTermsMenu.this.exportMenu.setEnabled(false);
                    KinTermsMenu.this.importMenu.setEnabled(false);
                    KinTermsMenu.this.hideShowMenu.setEnabled(false);
                    KinTermsMenu.this.newMenu.setEnabled(false);
                    KinTermsMenu.this.deleteMenu.setEnabled(false);
                }
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.hideShowMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermsMenu.this.currentKinTermSavePanel.setPanelState(VisiblePanelSetting.PanelType.KinTerms, KinTermsMenu.this.hideShowMenu.isSelected());
            }
        });
        this.exportMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermsMenu.this.currentKinTermSavePanel.exportKinTerms();
            }
        });
        this.importMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermsMenu.this.currentKinTermSavePanel.importKinTerms();
            }
        });
        this.newMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KinTermsMenu.this.currentKinTermSavePanel.setPanelState(VisiblePanelSetting.PanelType.KinTerms, true);
                KinTermsMenu.this.currentKinTermSavePanel.addKinTermGroup();
            }
        });
    }
}

