/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.entityindexer.DatabaseUpdateHandler;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.entityindexer.QueryBuilder;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityArray;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kintypestrings.KinTypeElement;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifierArray;
import nl.mpi.kinnate.userstorage.KinSessionStorage;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;

public class EntityCollection
extends DatabaseUpdateHandler {
    private final String databaseName;
    private final ProjectRecord projectRecord;
    private final ProjectManager projectManager;
    static final Context context = new Context();
    static final Object databaseLock = new Object();
    private final String dbErrorMessage = "Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.";

    public static void setGlobalDatabasePath(SessionStorage sessionStorage) throws EntityServiceException {
        try {
            File globalDatabaseDirectory = new File(sessionStorage.getApplicationSettingsDirectory(), "BaseXData");
            if (!globalDatabaseDirectory.exists()) {
                globalDatabaseDirectory.mkdir();
            }
            new Set((Object)"dbpath", (Object)globalDatabaseDirectory).execute(context);
        }
        catch (BaseXException exception2) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception2));
            throw new EntityServiceException("Could not set the database directory: " + exception2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityCollection(ProjectManager projectManager, ProjectRecord projectRecord) throws EntityServiceException {
        this.projectManager = projectManager;
        this.projectRecord = projectRecord;
        this.databaseName = projectRecord.getProjectUUID();
        try {
            Object object = databaseLock;
            synchronized (object) {
                new Open(this.databaseName).execute(context);
                new Close().execute(context);
            }
        }
        catch (BaseXException baseXException) {
            try {
                Object object = databaseLock;
                synchronized (object) {
                    new CreateDB(this.databaseName).execute(context);
                    new Close().execute(context);
                    this.updateProjectRecord();
                }
            }
            catch (BaseXException exception2) {
                BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception2));
                throw new EntityServiceException("Could not create database:" + exception2.getMessage());
            }
        }
    }

    public ProjectRecord getProjectRecord() {
        return this.projectRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjectRecord() {
        long startTime = System.currentTimeMillis();
        try {
            Object object = databaseLock;
            synchronized (object) {
                QueryBuilder queryBuilder = new QueryBuilder();
                String databaseStatsQuery = queryBuilder.getDatabaseStats(this.databaseName);
                String queryResult = new XQuery(databaseStatsQuery).execute(context);
                String[] statsArray = queryResult.split(":");
                int entityCount = Integer.parseInt(statsArray[0]);
                int relationCount = Integer.parseInt(statsArray[1]) / 2;
                this.projectRecord.setEntityCount(entityCount);
                this.projectRecord.setRelationCount(relationCount);
            }
        }
        catch (BaseXException baseXException) {
            this.projectRecord.setEntityCount(-1);
            this.projectRecord.setRelationCount(-1);
        }
        try {
            this.projectRecord.bumpLastChangeDate();
            this.projectManager.saveProjectRecord(this.projectRecord);
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
        }
        long queryMils = System.currentTimeMillis() - startTime;
        String queryTimeString = "updateProjectRecord time: " + queryMils + "milliseconds";
        System.out.println(queryTimeString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateDatabase() throws EntityServiceException {
        try {
            Object object = databaseLock;
            synchronized (object) {
                new DropDB(this.databaseName).execute(context);
                new Set((Object)"CREATEFILTER", (Object)"*.kmdi").execute(context);
                new CreateDB(this.databaseName, this.projectRecord.getProjectDataFilesDirectory().toString()).execute(context);
            }
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not recreate database:" + exception.getMessage());
        }
        this.updateProjectRecord();
        this.updateOccured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context openExistingExportDatabase(String exportDatabaseName) throws BaseXException {
        Context tempDbContext = new Context();
        Object object = databaseLock;
        synchronized (object) {
            new Open(exportDatabaseName).execute(tempDbContext);
        }
        return tempDbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropExportDatabase(Context tempDbContext, String exportDatabaseName) throws BaseXException {
        Object object = databaseLock;
        synchronized (object) {
            new DropDB(exportDatabaseName).execute(tempDbContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createExportDatabase(File directoryOfInputFiles, String suffixFilter, String exportDatabaseName) throws BaseXException {
        if (suffixFilter == null) {
            suffixFilter = "*.kmdi";
        }
        Context tempDbContext = new Context();
        Object object = databaseLock;
        synchronized (object) {
            new DropDB(exportDatabaseName).execute(tempDbContext);
            new Set((Object)"CREATEFILTER", (Object)suffixFilter).execute(tempDbContext);
            new CreateDB(exportDatabaseName, directoryOfInputFiles.toString()).execute(tempDbContext);
        }
        return tempDbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performExportQuery(Context tempDbContext, String exportDatabaseName, String exportQueryString) throws BaseXException {
        if (tempDbContext == null) {
            tempDbContext = context;
        }
        String returnString = null;
        Object object = databaseLock;
        synchronized (object) {
            if (exportDatabaseName != null) {
                new Close().execute(context);
                new Open(exportDatabaseName).execute(tempDbContext);
            }
            returnString = new XQuery(exportQueryString).execute(tempDbContext);
            if (exportDatabaseName != null) {
                new Close().execute(tempDbContext);
                new Open(this.databaseName).execute(context);
            }
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDatabase() {
        try {
            Object object = databaseLock;
            synchronized (object) {
                new DropDB(this.databaseName).execute(context);
                System.out.println("List: " + new List().execute(context));
            }
        }
        catch (BaseXException baseXException) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)baseXException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToDB(URI updatedDataUrl, UniqueIdentifier updatedFileIdentifier) throws EntityServiceException {
        String urlString = updatedDataUrl.toASCIIString();
        try {
            Object object = databaseLock;
            synchronized (object) {
                this.runDeleteQuery(updatedFileIdentifier);
                new Add(this.projectRecord.getProjectDataFilesDirectory().toURI().relativize(updatedDataUrl).toASCIIString(), urlString).execute(context);
            }
        }
        catch (BaseXException baseXException) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)baseXException));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Add file to database:" + baseXException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromDatabase(UniqueIdentifier updatedFileIdentifier) throws EntityServiceException {
        try {
            Object object = databaseLock;
            synchronized (object) {
                new Open(this.databaseName).execute(context);
                this.runDeleteQuery(updatedFileIdentifier);
                new Close().execute(context);
            }
            this.updateProjectRecord();
            this.updateOccured();
        }
        catch (BaseXException baseXException) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)baseXException));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Delete file from database:" + baseXException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatabase(final UniqueIdentifier[] updatedFileArray, final JProgressBar progressBar) throws EntityServiceException {
        try {
            if (progressBar != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressBar.setMinimum(0);
                        progressBar.setMaximum(updatedFileArray.length);
                        progressBar.setIndeterminate(false);
                        progressBar.setValue(0);
                    }
                });
            }
            Object object = databaseLock;
            synchronized (object) {
                new Open(this.databaseName).execute(context);
                for (UniqueIdentifier updatedUniqueIdentifier : updatedFileArray) {
                    this.addFileToDB(updatedUniqueIdentifier.getFileInProject(this.projectRecord).toURI(), updatedUniqueIdentifier);
                    if (progressBar == null) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressBar.setValue(progressBar.getValue() + 1);
                        }
                    });
                }
                if (progressBar != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressBar.setIndeterminate(true);
                        }
                    });
                }
                if (progressBar != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressBar.setIndeterminate(false);
                        }
                    });
                }
                new Close().execute(context);
            }
            this.updateProjectRecord();
            this.updateOccured();
        }
        catch (BaseXException baseXException) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)baseXException));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Update database:" + baseXException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatabase(URI updatedFile, UniqueIdentifier updatedFileIdentifier) throws EntityServiceException {
        try {
            Object object = databaseLock;
            synchronized (object) {
                new Open(this.databaseName).execute(context);
                this.addFileToDB(updatedFile, updatedFileIdentifier);
                new Close().execute(context);
            }
            this.updateProjectRecord();
            this.updateOccured();
        }
        catch (BaseXException baseXException) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)baseXException));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Update database:" + baseXException.getMessage());
        }
    }

    public SearchResults searchForLocalEntites() throws EntityServiceException {
        String queryString = "for $doc in collection('nl-mpi-kinnate') where exists(/*:Kinnate/*:Entity/*:Identifier/@*:type=\"lid\") return base-uri($doc)";
        return this.performQuery(queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResults performQuery(String queryString) throws EntityServiceException {
        SearchResults searchResults = new SearchResults();
        ArrayList<String> resultPaths = new ArrayList<String>();
        try {
            Object object = databaseLock;
            synchronized (object) {
                Item item;
                QueryProcessor proc = new QueryProcessor(queryString, context);
                Iter iter = proc.iter();
                while ((item = iter.next()) != null) {
                    resultPaths.add(item.toJava().toString());
                    ++searchResults.resultCount;
                }
                proc.close();
            }
            searchResults.statusMessage = "found " + searchResults.resultCount + " records";
        }
        catch (QueryException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            searchResults.statusMessage = exception.getMessage();
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Query database:" + exception.getMessage());
        }
        searchResults.resultsPathArray = resultPaths.toArray(new String[0]);
        return searchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueIdentifier[] getEntityIdByTerm(KinTypeElement queryTerms) throws EntityServiceException {
        UniqueIdentifier[] returnArray = new UniqueIdentifier[]{};
        QueryBuilder queryBuilder = new QueryBuilder();
        String queryString = queryBuilder.getTermQuery(queryTerms, this.databaseName);
        long startTime = System.currentTimeMillis();
        try {
            String queryResult;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UniqueIdentifierArray.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object object = databaseLock;
            synchronized (object) {
                queryResult = new XQuery(queryString).execute(context);
            }
            if (queryResult.length() > 0) {
                UniqueIdentifierArray identifierArray = (UniqueIdentifierArray)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(queryResult)), UniqueIdentifierArray.class).getValue();
                if (identifierArray != null && identifierArray.testIdentifiers != null) {
                    returnArray = identifierArray.testIdentifiers;
                }
                long queryMils = System.currentTimeMillis() - startTime;
                String queryTimeString = "Query time: " + queryMils + "milliseconds for " + returnArray.length + " UniqueIdentifiers";
                System.out.println(queryTimeString);
            }
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Search database:" + exception.getMessage());
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Search database:" + exception.getMessage());
        }
        return returnArray;
    }

    public EntityData[] getEntityByEndPoint(DataTypes.RelationType relationType, IndexerParameters indexParameters) throws EntityServiceException {
        QueryBuilder queryBuilder = new QueryBuilder();
        String query1String = queryBuilder.getEntityByEndPointQuery(relationType, indexParameters, this.databaseName);
        return this.getEntityByQuery(query1String, indexParameters);
    }

    public EntityData[] getEntityByKeyWord(String keyWords, IndexerParameters indexParameters) throws EntityServiceException {
        QueryBuilder queryBuilder = new QueryBuilder();
        String query1String = queryBuilder.getEntityByKeyWordQuery(keyWords, indexParameters, this.databaseName);
        return this.getEntityByQuery(query1String, indexParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityData[] getEntityByQuery(String query1String, IndexerParameters indexParameters) throws EntityServiceException {
        long startTime = System.currentTimeMillis();
        try {
            String queryResult;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityArray.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object object = databaseLock;
            synchronized (object) {
                queryResult = new XQuery(query1String).execute(context);
            }
            EntityArray foundEntities = (EntityArray)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(queryResult)), EntityArray.class).getValue();
            long queryMils = System.currentTimeMillis() - startTime;
            EntityData[] entityDataArray = foundEntities.getEntityDataArray();
            int resultCount = 0;
            if (entityDataArray != null) {
                resultCount = entityDataArray.length;
            }
            String queryTimeString = "Query time: " + queryMils + "milliseconds for " + resultCount + " entities";
            System.out.println(queryTimeString);
            return foundEntities.getEntityDataArray();
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Search database by keyword:" + exception.getMessage());
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Search database by keyword:" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityData[] getEntityWithRelations(UniqueIdentifier uniqueIdentifier, String[] excludeUniqueIdentifiers, IndexerParameters indexParameters) throws EntityServiceException {
        long startTime = System.currentTimeMillis();
        QueryBuilder queryBuilder = new QueryBuilder();
        String query1String = queryBuilder.getEntityWithRelationsQuery(uniqueIdentifier, excludeUniqueIdentifiers, indexParameters, this.databaseName);
        try {
            String queryResult;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityData.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object object = databaseLock;
            synchronized (object) {
                queryResult = new XQuery(query1String).execute(context);
            }
            EntityData[] selectedEntity = (EntityData[])unmarshaller.unmarshal((Source)new StreamSource(new StringReader(queryResult)), EntityData[].class).getValue();
            long queryMils = System.currentTimeMillis() - startTime;
            String queryTimeString = "Query time: " + queryMils + "milliseconds for " + selectedEntity.length + " entities";
            System.out.println(queryTimeString);
            return selectedEntity;
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Get entity with relations:" + exception.getMessage());
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Get entity with relations:" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDeleteQuery(UniqueIdentifier uniqueIdentifier) throws EntityServiceException {
        QueryBuilder queryBuilder = new QueryBuilder();
        String query1String = queryBuilder.getDeleteQuery(uniqueIdentifier, this.databaseName);
        try {
            long startQueryTime = System.currentTimeMillis();
            Object object = databaseLock;
            synchronized (object) {
                String queryResult = new XQuery(query1String).execute(context);
            }
            long queryMils = System.currentTimeMillis() - startQueryTime;
            System.out.println("Query time: " + queryMils + "milliseconds");
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Delete from database:" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllFieldNames() throws EntityServiceException {
        QueryBuilder queryBuilder = new QueryBuilder();
        String allFieldNamesQuery = queryBuilder.getAllFieldNamesQuery(this.databaseName);
        String queryResult = "";
        try {
            Object object = databaseLock;
            synchronized (object) {
                queryResult = new XQuery(allFieldNamesQuery).execute(context);
            }
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError(allFieldNamesQuery + "\n" + queryResult, (Exception)((Object)exception));
            throw new EntityServiceException("Could not perform the required query, not all data might be shown at this point.\nSee the log file via the help menu for more details.\n Get field names:" + exception.getMessage());
        }
        return queryResult.split(" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityData getEntity(UniqueIdentifier uniqueIdentifier, IndexerParameters indexParameters) {
        QueryBuilder queryBuilder = new QueryBuilder();
        String query1String = queryBuilder.getEntityQuery(uniqueIdentifier, indexParameters, this.databaseName);
        String queryResult = "";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityData.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object object = databaseLock;
            synchronized (object) {
                queryResult = new XQuery(query1String).execute(context);
            }
            EntityData selectedEntity = (EntityData)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(queryResult)), EntityData.class).getValue();
            return selectedEntity;
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError(query1String + "\n" + queryResult, (Exception)((Object)exception));
            return new EntityData(uniqueIdentifier, new String[]{"Error loading the entity data", "view log for details"});
        }
        catch (BaseXException exception) {
            BugCatcherManager.getBugCatcher().logError(query1String + "\n" + queryResult, (Exception)((Object)exception));
            return new EntityData(uniqueIdentifier, new String[]{"Error in db query", "view log for details"});
        }
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame("Test Query Window");
        jFrame.setDefaultCloseOperation(3);
        final JTextArea queryText = new JTextArea();
        final JLabel queryTimeLabel = new JLabel();
        final ArbilWindowManager arbilWindowManager = new ArbilWindowManager();
        KinSessionStorage kinSessionStorage = new KinSessionStorage(new ApplicationVersionManager((ApplicationVersion)new KinOathVersion()));
        try {
            ProjectManager projectManager1 = new ProjectManager((SessionStorage)kinSessionStorage, arbilWindowManager);
            final EntityCollection entityCollection = projectManager1.getEntityCollectionForProject(new ProjectRecord(kinSessionStorage.getProjectDirectory(), kinSessionStorage.getProjectDirectory().getName()));
            queryText.setText("for $entityNode in collection('nl-mpi-kinnate')/*:Kinnate[(*:Entity|*:Gedcom)/*:UniqueIdentifier/. = \"e4dfbd92d311088bf692211ced5179e5\"]\nreturn<Entity>{\n<Identifier>{$entityNode/(*:Entity|*:Gedcom)/*:UniqueIdentifier//text()}</Identifier>,\n<DateOfBirth>{$entityNode/(*:Entity|*:Gedcom)/DOB}</DateOfBirth>,\n<Path>{base-uri($entityNode)}</Path>\n}</Entity>\n");
            final JTextArea resultsText = new JTextArea();
            resultsText.setVisible(false);
            JButton jButton = new JButton("run query");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    resultsText.setText("");
                    try {
                        long startTime = System.currentTimeMillis();
                        resultsText.append(new XQuery(queryText.getText()).execute(context));
                        long queryMils = System.currentTimeMillis() - startTime;
                        String queryTimeString = "Query time: " + queryMils + "milliseconds";
                        queryTimeLabel.setText(queryTimeString);
                    }
                    catch (BaseXException exception) {
                        resultsText.append(exception.getMessage());
                        arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Action Performed");
                    }
                    resultsText.setVisible(true);
                }
            });
            JButton dropButton = new JButton("drop database");
            dropButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    resultsText.setText("");
                    entityCollection.dropDatabase();
                    resultsText.setVisible(true);
                }
            });
            JButton recreateButton = new JButton("drop and recreate database");
            recreateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    resultsText.setText("recreating database");
                    try {
                        entityCollection.recreateDatabase();
                        resultsText.setText("done\n");
                    }
                    catch (EntityServiceException exception) {
                        resultsText.append(exception.getMessage());
                    }
                    resultsText.setVisible(true);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)queryText, "Center");
            jPanel.add((Component)resultsText, "Last");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(jButton);
            buttonPanel.add(dropButton);
            buttonPanel.add(recreateButton);
            buttonPanel.add(queryTimeLabel);
            jPanel.add((Component)buttonPanel, "First");
            jFrame.setContentPane(new JScrollPane(jPanel));
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (EntityServiceException exception) {
            System.out.println(exception.getMessage());
        }
    }

    public class SearchResults {
        public String[] resultsPathArray;
        public String statusMessage;
        public int resultCount = 0;
    }
}

