/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.kintypeeditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.kintypeeditor.CheckBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTypeTableModel
extends AbstractTableModel
implements ActionListener,
CheckBoxModel {
    SavePanel savePanel;
    DataStoreSvg dataStoreSvg;
    HashSet<KinType> checkBoxSet = new HashSet();
    JButton deleteSelectedButton;

    public KinTypeTableModel(SavePanel savePanel, DataStoreSvg dataStoreSvg, JButton deleteSelectedButton) {
        this.savePanel = savePanel;
        this.dataStoreSvg = dataStoreSvg;
        this.deleteSelectedButton = deleteSelectedButton;
        deleteSelectedButton.setEnabled(false);
        deleteSelectedButton.addActionListener(this);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Kin Type String";
            }
            case 1: {
                return "Relation Type";
            }
            case 2: {
                return "Symbol Type";
            }
            case 3: {
                return "Display Name";
            }
            case 4: {
                return "";
            }
        }
        throw new UnsupportedOperationException("Too many columns");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.dataStoreSvg.getKinTypeDefinitions().length + 1;
    }

    @Override
    public ArrayList<String> getValueRangeAt(int columnIndex) {
        ArrayList<String> valuesList = new ArrayList<String>();
        switch (columnIndex) {
            case 0: {
                throw new UnsupportedOperationException("Not a list row type");
            }
            case 1: {
                for (DataTypes.RelationType relationType : DataTypes.RelationType.values()) {
                    valuesList.add(relationType.name());
                }
                break;
            }
            case 2: {
                for (EntityData.SymbolType symbolType : EntityData.SymbolType.values()) {
                    valuesList.add(symbolType.name());
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not a list row type");
            }
        }
        return valuesList;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.dataStoreSvg.getKinTypeDefinitions().length) {
            KinType kinType = this.dataStoreSvg.getKinTypeDefinitions()[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return kinType.getCodeString();
                }
                case 1: {
                    DataTypes.RelationType[] relationTypes = kinType.getRelationTypes();
                    if (relationTypes == null) {
                        return null;
                    }
                    ArrayList<String> valuesList = new ArrayList<String>();
                    for (DataTypes.RelationType relationType : relationTypes) {
                        valuesList.add(relationType.name());
                    }
                    return valuesList;
                }
                case 2: {
                    EntityData.SymbolType[] symbolTypes = kinType.getSymbolTypes();
                    if (symbolTypes == null) {
                        return null;
                    }
                    ArrayList<String> valuesList1 = new ArrayList<String>();
                    for (EntityData.SymbolType symbolType : symbolTypes) {
                        valuesList1.add(symbolType.name());
                    }
                    return valuesList1;
                }
                case 3: {
                    return kinType.getDisplayString();
                }
                case 4: {
                    return this.checkBoxSet.contains(kinType);
                }
            }
            throw new UnsupportedOperationException("Too many columns");
        }
        switch (columnIndex) {
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
            case 4: {
                return false;
            }
        }
        return "";
    }

    @Override
    public void setListValueAt(ArrayList<String> valuesList, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                throw new UnsupportedOperationException("Not a list type");
            }
            case 1: {
                ArrayList<DataTypes.RelationType> relationTypeList = new ArrayList<DataTypes.RelationType>();
                for (String stringValue : valuesList) {
                    relationTypeList.add(DataTypes.RelationType.valueOf(stringValue));
                }
                this.setValueAt(relationTypeList.toArray(new DataTypes.RelationType[0]), rowIndex, columnIndex);
                break;
            }
            case 2: {
                ArrayList<EntityData.SymbolType> symbolTypeList = new ArrayList<EntityData.SymbolType>();
                for (String stringValue : valuesList) {
                    symbolTypeList.add(EntityData.SymbolType.valueOf(stringValue));
                }
                this.setValueAt(symbolTypeList.toArray(new EntityData.SymbolType[0]), rowIndex, columnIndex);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not a list type");
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        KinType[] kinTypeDefinitions = this.dataStoreSvg.getKinTypeDefinitions();
        if (rowIndex >= this.dataStoreSvg.getKinTypeDefinitions().length && columnIndex == 4) {
            if (this.checkBoxSet.isEmpty()) {
                this.checkBoxSet.addAll(Arrays.asList(kinTypeDefinitions));
            } else {
                this.checkBoxSet.clear();
            }
            this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
            this.fireTableDataChanged();
            return;
        }
        String codeString = "undefined";
        DataTypes.RelationType[] relationType = null;
        EntityData.SymbolType[] symbolType = null;
        String displayString = "";
        KinType kinType = null;
        if (rowIndex < this.dataStoreSvg.getKinTypeDefinitions().length) {
            kinType = kinTypeDefinitions[rowIndex];
            codeString = kinType.getCodeString();
            relationType = kinType.getRelationTypes();
            symbolType = kinType.getSymbolTypes();
            displayString = kinType.getDisplayString();
        }
        switch (columnIndex) {
            case 0: {
                codeString = aValue.toString();
                break;
            }
            case 1: {
                if (aValue instanceof DataTypes.RelationType[]) {
                    relationType = (DataTypes.RelationType[])aValue;
                    break;
                }
                if (aValue != null) break;
                relationType = null;
                break;
            }
            case 2: {
                if (aValue instanceof EntityData.SymbolType[]) {
                    symbolType = (EntityData.SymbolType[])aValue;
                    break;
                }
                if (aValue != null) break;
                symbolType = null;
                break;
            }
            case 3: {
                displayString = aValue.toString();
                break;
            }
            case 4: {
                if (((Boolean)aValue).booleanValue()) {
                    this.checkBoxSet.add(kinType);
                } else {
                    this.checkBoxSet.remove(kinType);
                }
                this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
                this.fireTableDataChanged();
                return;
            }
            default: {
                throw new UnsupportedOperationException("Too many columns");
            }
        }
        if (rowIndex < this.dataStoreSvg.getKinTypeDefinitions().length) {
            kinTypeDefinitions[rowIndex] = new KinType(codeString, relationType, symbolType, displayString);
            this.dataStoreSvg.setKinTypeDefinitions(kinTypeDefinitions);
        } else {
            if ("".equals(aValue)) {
                return;
            }
            ArrayList<KinType> kinTypesList = new ArrayList<KinType>(Arrays.asList(kinTypeDefinitions));
            kinTypesList.add(new KinType(codeString, relationType, symbolType, displayString));
            this.dataStoreSvg.setKinTypeDefinitions(kinTypesList.toArray(new KinType[0]));
        }
        this.savePanel.updateGraph();
        this.savePanel.requiresSave();
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<KinType> kinTypesList = new ArrayList<KinType>(Arrays.asList(this.dataStoreSvg.getKinTypeDefinitions()));
        for (KinType kinType : this.checkBoxSet) {
            kinTypesList.remove(kinType);
        }
        this.dataStoreSvg.setKinTypeDefinitions(kinTypesList.toArray(new KinType[0]));
        this.checkBoxSet.clear();
        this.fireTableDataChanged();
        this.savePanel.updateGraph();
    }
}

