/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.io.IOFile;
import org.basex.util.Table;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class ShowBackups
extends Command {
    public ShowBackups() {
        super(Perm.CREATE, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        Table table = new Table();
        table.description = Text.BACKUPS;
        table.header.add(Text.NAME);
        table.header.add(Text.SIZE);
        for (IOFile f : this.mprop.dbpath().children()) {
            String name = f.name();
            if (!name.endsWith(".zip")) continue;
            TokenList tl = new TokenList();
            tl.add(name);
            tl.add(f.length());
            table.contents.add(tl);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        return true;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.SHOW) + " " + (Object)((Object)Commands.CmdShow.BACKUPS));
    }
}

