/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import org.basex.core.Prop;
import org.basex.core.cmd.XQuery;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.view.editor.EditorView;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.Performance;
import org.basex.util.Token;

final class EditorArea
extends BaseXEditor {
    final BaseXLabel label;
    IOFile file;
    long tstamp;
    boolean modified;
    int threadID;
    byte[] last = Token.EMPTY;
    boolean executable = true;
    private final EditorView view;

    EditorArea(EditorView v, IOFile f) {
        super(true, v.gui);
        this.view = v;
        this.file = f;
        this.label = new BaseXLabel(f.name());
        this.setSyntax(f, false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (EditorArea.this.opened() && !EditorArea.this.modified) {
                    try {
                        long t = EditorArea.this.tstamp;
                        if (EditorArea.this.file.timeStamp() != t) {
                            EditorArea.this.setText(new IOFile(EditorArea.this.file.path()).read());
                            EditorArea.this.tstamp = t;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    boolean opened() {
        return this.tstamp != 0L;
    }

    @Override
    public void setText(byte[] t) {
        super.setText(t);
        this.last = this.getText();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.view.pos.setText(this.pos());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        byte[] t = this.text.text();
        super.keyPressed(e);
        if (t != this.text.text()) {
            this.error(-1);
        } else {
            this.view.pos.setText(this.pos());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        byte[] t = this.text.text();
        super.keyTyped(e);
        if (t != this.text.text()) {
            this.error(-1);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
        if (!e.isActionKey() && !BaseXKeys.modifier(e)) {
            this.release(BaseXKeys.EXEC.is(e));
        }
    }

    @Override
    protected void release(boolean force) {
        byte[] in = this.getText();
        boolean eq = Token.eq(in, this.last);
        if (eq && !force) {
            return;
        }
        this.last = in;
        this.view.refresh(this.modified || !eq, false);
        ++this.threadID;
        this.view.pos.setText(this.pos());
        this.gui.context.prop.set(Prop.QUERYPATH, this.file.path());
        if (this.opened() && !this.file.hasSuffix(IO.XQSUFFIXES)) {
            this.view.info("OK", true);
            this.executable = false;
        } else {
            String qu = in.length == 0 ? "()" : Token.string(in);
            boolean bl = this.executable = !EditorArea.module(in);
            if (this.executable && (force || this.gui.gprop.is(GUIProp.EXECRT))) {
                this.gui.execute(true, new XQuery(qu));
            } else {
                QueryContext ctx = new QueryContext(this.gui.context);
                try {
                    if (!this.executable) {
                        ctx.module(qu);
                    } else {
                        ctx.parse(qu);
                    }
                    this.view.info("OK", true);
                }
                catch (QueryException ex) {
                    this.view.info(ex.getMessage(), false);
                }
            }
        }
    }

    void query() {
        this.release(true);
    }

    IOFile file() {
        return this.file;
    }

    void file(IOFile f) {
        this.file = f;
        this.tstamp = f.timeStamp();
        this.setSyntax(this.file, true);
    }

    void jumpError(int pos) {
        this.requestFocusInWindow();
        this.setCaret(pos);
    }

    void markError(final int pos) {
        final int thread = this.threadID;
        new Thread(){

            @Override
            public void run() {
                Performance.sleep(pos == -1 ? 0L : 500L);
                if (thread == EditorArea.this.threadID) {
                    EditorArea.this.error(pos);
                }
            }
        }.start();
    }

    private static boolean module(byte[] qu) {
        String mod = "module namespace ";
        return QueryProcessor.removeComments(Token.string(qu), "module namespace ".length() + 1).startsWith("module namespace ");
    }
}

