/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class Cast
extends Single {
    public Cast(InputInfo ii, Expr e, SeqType t) {
        super(ii, e);
        this.type = t;
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        if (this.expr.type().one()) {
            this.type = SeqType.get(this.type.type, SeqType.Occ.ONE);
        }
        if (this.expr.isValue()) {
            return this.preEval(ctx);
        }
        Type t = this.type.type;
        if ((t == AtomType.BLN || t == AtomType.FLT || t == AtomType.DBL || t == AtomType.QNM || t == AtomType.URI) && this.type.eq(this.expr.type())) {
            this.optPre(this.expr, ctx);
            return this.expr;
        }
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.type.cast(this.expr.item(ctx, ii), true, ctx, ii, this);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.TYP, this.type), this.expr);
    }

    @Override
    public String toString() {
        return this.expr + " " + "cast" + ' ' + "as" + ' ' + this.type;
    }
}

