/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringRange;
import org.basex.query.QueryContext;
import org.basex.query.QueryText;
import org.basex.query.expr.IndexAccess;
import org.basex.query.func.Function;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class StringRangeAccess
extends IndexAccess {
    final StringRange sr;

    public StringRangeAccess(InputInfo ii, StringRange t, IndexContext ic) {
        super(ic, ii);
        this.sr = t;
    }

    @Override
    public AxisIter iter(QueryContext ctx) {
        final Data data = this.ictx.data;
        boolean text = this.sr.type == IndexType.TEXT;
        final byte kind = text ? (byte)2 : 3;
        int ml = data.meta.maxlen;
        final IndexIterator ii = this.sr.min.length <= ml && this.sr.max.length <= ml && (text ? data.meta.textindex : data.meta.attrindex) ? data.iter(this.sr) : this.scan();
        return new AxisIter(){

            @Override
            public ANode next() {
                return ii.more() ? new DBNode(data, ii.next(), kind) : null;
            }
        };
    }

    private IndexIterator scan() {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            final Data data;
            int pre;
            {
                this.text = StringRangeAccess.this.sr.type == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.data = StringRangeAccess.this.ictx.data;
                this.pre = -1;
            }

            @Override
            public int next() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.data.meta.size) {
                    if (this.data.kind(this.pre) != this.kind) continue;
                    byte[] t = this.data.text(this.pre, this.text);
                    int mn = Token.diff(t, StringRangeAccess.this.sr.min);
                    int mx = Token.diff(t, StringRangeAccess.this.sr.max);
                    if (mn < (StringRangeAccess.this.sr.mni ? 0 : 1) || mx > (StringRangeAccess.this.sr.mxi ? 0 : 1)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[]{QueryText.DATA, this.ictx.data.meta.name, QueryText.MIN, this.sr.min, QueryText.MAX, this.sr.max, QueryText.TYP, this.sr.type}), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        return (this.sr.type == IndexType.TEXT ? Function._DB_TEXT_RANGE : Function._DB_ATTRIBUTE_RANGE).get(this.info, Str.get(this.ictx.data.meta.name), Str.get(this.sr.min), Str.get(this.sr.max)).toString();
    }
}

