/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class Try
extends Single {
    private QueryException qe;
    private final Catch[] ctch;

    public Try(InputInfo ii, Expr t, Catch[] c) {
        super(ii, t);
        this.ctch = c;
    }

    @Override
    public void checkUp() throws QueryException {
        Expr[] tmp = new Expr[this.ctch.length + 1];
        tmp[0] = this.expr;
        for (int c = 0; c < this.ctch.length; ++c) {
            tmp[c + 1] = this.ctch[c].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        if (this.qe == null) {
            try {
                super.compile(ctx);
                if (this.expr.isValue()) {
                    return this.optPre(this.expr, ctx);
                }
            }
            catch (QueryException ex) {
                this.qe = ex;
            }
        }
        for (Catch c : this.ctch) {
            c.compile(ctx);
        }
        this.type = this.expr.type();
        for (Catch c : this.ctch) {
            this.type = this.type.intersect(c.type());
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext ctx) throws QueryException {
        int s = ctx.vars.size();
        try {
            if (this.qe != null) {
                Value value = this.err(ctx, this.qe);
                return value;
            }
            Value value = ctx.value(this.expr);
            return value;
        }
        finally {
            ctx.vars.size(s);
        }
    }

    private Value err(QueryContext ctx, QueryException ex) throws QueryException {
        for (Catch c : this.ctch) {
            Value val = c.value(ctx, ex);
            if (val == null) continue;
            return val;
        }
        throw ex;
    }

    @Override
    public int count(Var v) {
        int c = super.count(v);
        for (Catch ct : this.ctch) {
            c += ct.count(v);
        }
        return c;
    }

    @Override
    public boolean uses(Expr.Use u) {
        for (Catch c : this.ctch) {
            if (!c.uses(u)) continue;
            return true;
        }
        return super.uses(u);
    }

    @Override
    public boolean removable(Var v) {
        for (Catch c : this.ctch) {
            if (c.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        for (Catch c : this.ctch) {
            c.remove(v);
        }
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        for (Catch c : this.ctch) {
            if (c.databases(db)) continue;
            return false;
        }
        return super.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.expr, this.ctch});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("try { " + this.expr + " }");
        for (Catch c : this.ctch) {
            sb.append(' ').append(c);
        }
        return sb.toString();
    }
}

