/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.util.Map;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FNXQuery
extends StandardFunc {
    public FNXQuery(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _XQUERY_EVAL: {
                return this.eval(ctx).iter();
            }
            case _XQUERY_INVOKE: {
                return this.invoke(ctx).iter();
            }
            case _XQUERY_TYPE: {
                return this.value(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _XQUERY_EVAL: {
                return this.eval(ctx);
            }
            case _XQUERY_INVOKE: {
                return this.invoke(ctx);
            }
            case _XQUERY_TYPE: {
                return this.comp(ctx).value(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    Expr comp(QueryContext ctx) throws QueryException {
        if (this.sig == Function._XQUERY_TYPE) {
            FNInfo.dump(Util.inf("{ type: %, size: % }", this.expr[0].type(), this.expr[0].size()), Token.token(this.expr[0].toString()), ctx);
            return this.expr[0];
        }
        return this;
    }

    private Value eval(QueryContext ctx) throws QueryException {
        return this.eval(ctx, this.checkStr(this.expr[0], ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value eval(QueryContext ctx, byte[] qu) throws QueryException {
        QueryContext qc = new QueryContext(ctx.context);
        for (Map.Entry<String, Value> it : this.bindings(1, ctx).entrySet()) {
            String k = it.getKey();
            Value v = it.getValue();
            if (k.isEmpty()) {
                qc.context(v, null);
                continue;
            }
            qc.bind(k, v, null);
        }
        try {
            qc.parse(Token.string(qu));
            if (qc.updating) {
                Err.BXXQ_UPDATING.thrw(this.info, new Object[0]);
            }
            qc.compile();
            Value value = qc.value();
            return value;
        }
        finally {
            qc.close();
        }
    }

    private Value invoke(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        String path = Token.string(this.checkStr(this.expr[0], ctx));
        IO io = IO.get(path);
        if (!io.exists()) {
            Err.WHICHRES.thrw(this.info, path);
        }
        try {
            return this.eval(ctx, io.read());
        }
        catch (IOException ex) {
            throw Err.IOERR.thrw(this.info, ex);
        }
    }

    static void dump(long min, byte[] msg, QueryContext ctx) {
        Performance.gc(2);
        long max = Performance.memory();
        long mb = Math.max(0L, max - min);
        FNInfo.dump(Token.token(Performance.format(mb)), msg, ctx);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT && FNXQuery.oneOf(this.sig, Function._XQUERY_EVAL, Function._XQUERY_INVOKE) || super.uses(u);
    }
}

