/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.index.path.PathSummary;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CAttr;
import org.basex.query.expr.CDoc;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Root;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisPath;
import org.basex.query.path.AxisStep;
import org.basex.query.path.Bang;
import org.basex.query.path.MixedPath;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public abstract class Path
extends ParseExpr {
    public Expr root;
    public Expr[] steps;

    Path(InputInfo ii, Expr r, Expr[] s) {
        super(ii);
        this.root = r;
        this.steps = s;
    }

    public static Path get(InputInfo ii, Expr r, Expr ... path) {
        boolean axes = true;
        for (Expr p : path) {
            axes &= p instanceof AxisStep;
        }
        return axes ? new AxisPath(ii, r, path).finish(null) : new MixedPath(ii, r, path);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        this.checkNoneUp(this.steps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr compile(QueryContext ctx) throws QueryException {
        if (this.root != null) {
            this.root = this.root.compile(ctx);
            if (this.root instanceof Context) {
                this.root = null;
            }
        }
        Value v = ctx.value;
        try {
            ctx.value = this.root(ctx);
            Expr expr = this.compilePath(ctx);
            return expr;
        }
        finally {
            ctx.value = v;
        }
    }

    protected abstract Expr compilePath(QueryContext var1) throws QueryException;

    final Value root(QueryContext ctx) {
        Value v;
        Value value = v = ctx != null ? ctx.value : null;
        if (this.root == null) {
            return v == null || v.type != NodeType.DOC ? v : null;
        }
        if (this.root.isValue()) {
            return (Value)this.root;
        }
        if (!(this.root instanceof Root) || v == null) {
            return null;
        }
        return v.size() != 1L ? v : Root.root(v);
    }

    @Override
    public final boolean uses(Expr.Use use) {
        if (use == Expr.Use.CTX) {
            return this.root == null || this.root.uses(use);
        }
        for (Expr s : this.steps) {
            if (!s.uses(use)) continue;
            return true;
        }
        return this.root != null && this.root.uses(use);
    }

    void optSteps(QueryContext ctx) {
        boolean opt = false;
        Expr[] st = this.steps;
        for (int l = 1; l < st.length; ++l) {
            if (!(st[l - 1] instanceof AxisStep) || !(st[l] instanceof AxisStep)) continue;
            AxisStep prev = (AxisStep)st[l - 1];
            AxisStep curr = (AxisStep)st[l];
            if (!prev.simple(Axis.DESCORSELF, false)) continue;
            if (curr.axis == Axis.CHILD && !curr.uses(Expr.Use.POS)) {
                int sl = st.length;
                Expr[] tmp = new Expr[sl - 1];
                System.arraycopy(st, 0, tmp, 0, l - 1);
                System.arraycopy(st, l, tmp, l - 1, sl - l);
                st = tmp;
                curr.axis = Axis.DESC;
                opt = true;
                continue;
            }
            if (curr.axis != Axis.ATTR || curr.uses(Expr.Use.POS)) continue;
            prev.test = new NameTest(false);
            opt = true;
        }
        if (opt) {
            ctx.compInfo("simplifying descendant-or-self step(s)", new Object[0]);
        }
        if (this.root == null && st.length == 1 && st[0] instanceof AxisStep) {
            AxisStep curr = (AxisStep)st[0];
            if (curr.axis == Axis.ATTR && curr.test.mode == Test.Mode.STD) {
                curr.type = SeqType.NOD_ZO;
            }
        }
        this.steps = st;
    }

    long size(QueryContext ctx) {
        Value rt = this.root(ctx);
        if (rt == null || rt.type != NodeType.DOC) {
            return -1L;
        }
        Data data = rt.data();
        if (data == null || !data.meta.uptodate || (long)data.resources.docs().size() != rt.size()) {
            return -1L;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        long m = 1L;
        for (int s = 0; s < this.steps.length; ++s) {
            AxisStep curr = this.axisStep(s);
            if (curr != null) {
                if ((nodes = curr.nodes(nodes, data)) != null) continue;
                return -1L;
            }
            if (s + 1 == this.steps.length) {
                m = this.steps[s].size();
                continue;
            }
            return -1L;
        }
        long sz = 0L;
        for (PathNode pn : nodes) {
            sz += (long)pn.stats.count;
        }
        return sz * m;
    }

    AxisStep voidStep(Expr[] stps) throws QueryException {
        for (int l = 0; l < stps.length; ++l) {
            AxisStep s = this.axisStep(l);
            if (s == null) continue;
            Axis sa = s.axis;
            if (l == 0) {
                if (this.root instanceof CAttr) {
                    if (sa != Axis.CHILD && sa != Axis.DESC) continue;
                    Err.ATTDESC.thrw(this.info, this.root);
                    continue;
                }
                if (!(this.root instanceof Root) && (!(this.root instanceof Value) || ((Value)this.root).type != NodeType.DOC) && !(this.root instanceof CDoc) || sa == Axis.CHILD || sa == Axis.DESC || sa == Axis.DESCORSELF || (sa == Axis.SELF || sa == Axis.ANCORSELF) && (s.test == Test.NOD || s.test == Test.DOC)) continue;
                Err.DOCAXES.thrw(this.info, new Object[]{this.root, sa});
                continue;
            }
            AxisStep ls = this.axisStep(l - 1);
            if (ls == null) continue;
            Axis lsa = ls.axis;
            if (sa == Axis.SELF || sa == Axis.DESCORSELF) {
                if (s.test == Test.NOD) continue;
                if (lsa == Axis.ATTR && s.test.type != NodeType.ATT) {
                    return s;
                }
                if (ls.test == Test.TXT && s.test != Test.TXT) {
                    return s;
                }
                if (sa == Axis.DESCORSELF) continue;
                QNm n1 = s.test.name;
                QNm n0 = ls.test.name;
                if (n0 == null || n1 == null || n1.eq(n0)) continue;
                return s;
            }
            if (!(sa == Axis.FOLLSIBL || sa == Axis.PRECSIBL ? lsa == Axis.ATTR : (sa == Axis.DESC || sa == Axis.CHILD || sa == Axis.ATTR ? lsa == Axis.ATTR || ls.test == Test.TXT || ls.test == Test.COM || ls.test == Test.PI : (sa == Axis.PARENT || sa == Axis.ANC) && ls.test == Test.DOC))) continue;
            return s;
        }
        return null;
    }

    Expr children(QueryContext ctx, Data data) {
        int s;
        if (!data.meta.uptodate || data.nspaces.globalNS() == null) {
            return this;
        }
        Path path = this;
        for (s = 0; s < this.steps.length; ++s) {
            ArrayList<PathNode> pn;
            AxisStep prev;
            AxisStep axisStep = prev = s > 0 ? this.axisStep(s - 1) : null;
            if (prev != null && prev.preds.length != 0) break;
            AxisStep curr = this.axisStep(s);
            if (curr == null || curr.axis != Axis.DESC || curr.uses(Expr.Use.POS) || (pn = this.pathNodes(data, s)) == null) continue;
            ArrayList<QNm> qnm = new ArrayList<QNm>();
            while (pn.get((int)0).par != null) {
                QNm nm = new QNm(data.tagindex.key(pn.get((int)0).name));
                if (nm.hasPrefix()) {
                    return this;
                }
                for (int j = 0; j < pn.size(); ++j) {
                    if (pn.get((int)0).name == pn.get((int)j).name) continue;
                    nm = null;
                }
                qnm.add(nm);
                pn = PathSummary.parent(pn);
            }
            ctx.compInfo("converting % to child steps", this.steps[s]);
            int ts = qnm.size();
            Expr[] stps = new Expr[ts + this.steps.length - s - 1];
            for (int t = 0; t < ts; ++t) {
                Expr[] preds = t == ts - 1 ? ((AxisStep)this.steps[s]).preds : new Expr[]{};
                QNm nm = (QNm)qnm.get(ts - t - 1);
                NameTest nt = nm == null ? new NameTest(false) : new NameTest(nm, Test.Mode.NAME, false);
                stps[t] = AxisStep.get(this.info, Axis.CHILD, nt, preds);
            }
            while (++s < this.steps.length) {
                stps[ts++] = this.steps[s];
            }
            path = Path.get(this.info, this.root, stps);
            break;
        }
        if (data.nspaces.size() == 0) {
            AxisStep st;
            block5: for (s = 0; s < path.steps.length && (st = path.axisStep(s)) != null && st.axis == Axis.CHILD; ++s) {
                if (st.test.mode == Test.Mode.ALL || st.test.mode == null) continue;
                if (st.test.mode != Test.Mode.NAME) break;
                int name = data.tagindex.id(st.test.name.local());
                for (PathNode pn : data.paths.desc(name, 1)) {
                    if (pn.level() != s + 1) continue;
                    continue block5;
                }
                ctx.compInfo("removing non-existing path %", path);
                return Empty.SEQ;
            }
        }
        return path;
    }

    AxisStep axisStep(int i) {
        return this.steps[i] instanceof AxisStep ? (AxisStep)this.steps[i] : null;
    }

    ArrayList<PathNode> pathNodes(Data data, int l) {
        if (!data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> in = data.paths.root();
        for (int s = 0; s <= l; ++s) {
            boolean desc;
            AxisStep curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            boolean bl = desc = curr.axis == Axis.DESC;
            if (!desc && curr.axis != Axis.CHILD || curr.test.mode != Test.Mode.NAME) {
                return null;
            }
            int name = data.tagindex.id(curr.test.name.local());
            ArrayList<PathNode> al = new ArrayList<PathNode>();
            for (PathNode pn : PathSummary.desc(in, desc)) {
                if (pn.kind != 1 || name != pn.name) continue;
                if (!al.isEmpty() && ((PathNode)al.get(0)).level() != pn.level()) {
                    return null;
                }
                al.add(pn);
            }
            if (al.size() == 0) {
                return null;
            }
            in = al;
        }
        return in;
    }

    public final Path addPreds(Expr ... pred) {
        this.steps[this.steps.length - 1] = this.axisStep(this.steps.length - 1).addPreds(pred);
        return Path.get(this.info, this.root, this.steps);
    }

    @Override
    public int count(Var v) {
        return this.root != null ? this.root.count(v) : 0;
    }

    @Override
    public boolean removable(Var v) {
        return this.root == null || this.root.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        if (this.root != null) {
            this.root = this.root.remove(v);
        }
        if (this.root instanceof Context) {
            this.root = null;
        }
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (Expr s : this.steps) {
            if (s.databases(db)) continue;
            return false;
        }
        if (this.root != null) {
            return this.root.databases(db);
        }
        db.add("");
        return true;
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.root, this.steps});
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            sb.append(this.root);
        }
        for (Expr s : this.steps) {
            if (sb.length() != 0) {
                sb.append(s instanceof Bang ? (char)'!' : '/');
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

