/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.json;

import org.basex.data.DataText;
import org.basex.query.QueryException;
import org.basex.query.util.XMLConverter;
import org.basex.query.util.json.JArray;
import org.basex.query.util.json.JAtom;
import org.basex.query.util.json.JBoolean;
import org.basex.query.util.json.JNull;
import org.basex.query.util.json.JNumber;
import org.basex.query.util.json.JObject;
import org.basex.query.util.json.JSONParser;
import org.basex.query.util.json.JString;
import org.basex.query.util.json.JStruct;
import org.basex.query.util.json.JValue;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjMap;

public final class JSONConverter
extends XMLConverter {
    private static final byte[] S = new byte[]{115};
    private static final byte[][] ATTRS = new byte[][]{Token.concat(DataText.T_BOOLEAN, S), Token.concat(DataText.T_NUMBER, S), Token.concat(Token.NULL, S), Token.concat(DataText.T_ARRAY, S), Token.concat(DataText.T_OBJECT, S)};
    private static final Class<?>[] CLASSES = new Class[]{JBoolean.class, JNumber.class, JNull.class, JArray.class, JObject.class};
    private static final QNm Q_TYPE = new QNm(DataText.T_TYPE);
    private final TokenObjMap<QNm> qnames = new TokenObjMap();
    private final TokenObjMap<Class<?>> types = new TokenObjMap();

    public JSONConverter(InputInfo ii) {
        super(ii);
    }

    @Override
    public ANode parse(byte[] in) throws QueryException {
        JStruct node = new JSONParser(in, this.info).parse();
        this.types.add(DataText.T_JSON, node.getClass());
        this.analyze(node);
        FElem root = this.create(DataText.T_JSON, node);
        this.attach(root);
        return root;
    }

    private void analyze(JValue value) {
        if (value instanceof JStruct) {
            JStruct n = (JStruct)value;
            for (int s = 0; s < n.size(); ++s) {
                boolean obj = value instanceof JObject;
                byte[] name = JSONConverter.convert(obj ? ((JObject)n).name(s) : DataText.T_VALUE);
                Class<?> clz = n.value(s).getClass();
                Class<?> type = this.types.get(name);
                if (type == null) {
                    this.types.add(name, clz);
                } else if (type != JValue.class && type != clz) {
                    this.types.add(name, JValue.class);
                }
                this.analyze(n.value(s));
            }
        }
    }

    private FElem create(byte[] name, JValue value) {
        boolean type;
        byte[] nm = JSONConverter.convert(name);
        FElem root = new FElem(this.qname(nm));
        Class<?> clz = this.types.get(nm);
        boolean bl = type = clz == null || clz == JValue.class;
        if (value instanceof JStruct) {
            boolean obj = value instanceof JObject;
            if (type) {
                root.add(Q_TYPE, value.type());
            }
            JStruct n = (JStruct)value;
            for (int s = 0; s < n.size(); ++s) {
                root.add(this.create(obj ? ((JObject)n).name(s) : DataText.T_VALUE, n.value(s)));
            }
        } else {
            byte[] v;
            JAtom a = (JAtom)value;
            if (type && !(a instanceof JString)) {
                root.add(Q_TYPE, a.type());
            }
            if ((v = a.value()) != null) {
                root.add(v);
            }
        }
        return root;
    }

    private void attach(FElem root) {
        int b;
        TokenBuilder[] builders = new TokenBuilder[CLASSES.length];
        for (b = 0; b < builders.length; ++b) {
            builders[b] = new TokenBuilder();
        }
        block1: for (int i = 1; i <= this.types.size(); ++i) {
            Class<?> clz = this.types.value(i);
            for (int b2 = 0; b2 < builders.length; ++b2) {
                if (clz != CLASSES[b2]) continue;
                if (!builders[b2].isEmpty()) {
                    builders[b2].add(32);
                }
                builders[b2].add(this.types.key(i));
                continue block1;
            }
        }
        for (b = 0; b < builders.length; ++b) {
            if (builders[b].isEmpty()) continue;
            root.add(this.qname(ATTRS[b]), builders[b].trim().finish());
        }
    }

    private static byte[] convert(byte[] name) {
        TokenBuilder tb = new TokenBuilder();
        for (int n = 0; n < name.length; n += Token.cl(name, n)) {
            int cp = Token.cp(name, n);
            if (cp == 95) {
                tb.add(95).add(95);
                continue;
            }
            if (n == 0 ? XMLToken.isNCStartChar(cp) : XMLToken.isNCChar(cp)) {
                tb.add(cp);
                continue;
            }
            tb.add(95);
            byte[] buf = new byte[4];
            int p = buf.length;
            do {
                int b = cp & 0xF;
                buf[--p] = (byte)(b + (b > 9 ? 55 : 48));
                cp >>>= 4;
            } while (p != 0);
            tb.add(buf);
        }
        if (tb.isEmpty()) {
            tb.add(95);
        }
        return tb.finish();
    }

    private QNm qname(byte[] name) {
        QNm qname = this.qnames.get(name);
        if (qname == null) {
            qname = new QNm(name);
            this.qnames.add(name, qname);
        }
        return qname;
    }
}

