/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.json;

import org.basex.data.DataText;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.XMLConverter;
import org.basex.query.util.json.JArray;
import org.basex.query.util.json.JObject;
import org.basex.query.util.json.JSONParser;
import org.basex.query.util.json.JString;
import org.basex.query.util.json.JValue;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjMap;

public final class JsonMLConverter
extends XMLConverter {
    private final TokenObjMap<QNm> qnames = new TokenObjMap();

    public JsonMLConverter(InputInfo ii) {
        super(ii);
    }

    @Override
    public ANode parse(byte[] in) throws QueryException {
        return this.create(new JSONParser(in, this.info).parse());
    }

    private FElem create(JValue value) throws QueryException {
        return this.elem((JArray)this.check(value, DataText.T_ARRAY, "element constructor"));
    }

    private FElem elem(JArray value) throws QueryException {
        FElem elem = null;
        boolean txt = false;
        for (int s = 0; s < value.size(); ++s) {
            JValue val = value.value(s);
            if (s == 0) {
                JString str = (JString)this.check(val, DataText.T_STRING, "element name");
                elem = new FElem(this.qname(str.value));
                continue;
            }
            if (s == 1 && val instanceof JObject) {
                this.attr(elem, (JObject)val);
                continue;
            }
            if (val instanceof JArray) {
                elem.add(this.elem((JArray)val));
                txt = false;
                continue;
            }
            if (val instanceof JString) {
                if (txt) {
                    this.error("No subsequent texts allowed", new Object[0]);
                }
                txt = true;
                elem.add(((JString)val).value);
                continue;
            }
            this.error("No % allowed at this stage", new Object[]{val.type()});
        }
        if (elem == null) {
            this.error("No element name specified in array", new Object[0]);
        }
        return elem;
    }

    private void attr(FElem elem, JObject attr) throws QueryException {
        for (int s = 0; s < attr.size(); ++s) {
            JString v = (JString)this.check(attr.value(s), DataText.T_STRING, "attribute value");
            elem.add(this.qname(attr.name(s)), v.value);
        }
    }

    private QNm qname(byte[] name) throws QueryException {
        QNm qname = this.qnames.get(name);
        if (qname == null) {
            if (!XMLToken.isNCName(name)) {
                this.error("Invalid name: \"%\"", new Object[]{name});
            }
            qname = new QNm(name);
            this.qnames.add(name, qname);
        }
        return qname;
    }

    private JValue check(JValue val, byte[] type, String ext) throws QueryException {
        if (!Token.eq(val.type(), type)) {
            this.error("% expected for %, % found", type, ext, val.type());
        }
        return val;
    }

    private void error(String msg, Object ... ext) throws QueryException {
        throw Err.BXJS_PARSEML.thrw(this.info, new Object[]{Util.inf(msg, ext)});
    }
}

