/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Int;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Dtm
extends ADate {
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public Dtm(ADate d) {
        super(AtomType.DTM, d);
        if (this.xc.getHour() == Integer.MIN_VALUE) {
            this.xc.setHour(0);
            this.xc.setMinute(0);
            this.xc.setSecond(0);
        }
    }

    public Dtm(byte[] dt, InputInfo ii) throws QueryException {
        super(AtomType.DTM, dt, "2000-12-31T23:59:59", ii);
        int i = Token.indexOf(dt, 84);
        if (i == -1) {
            this.dateErr(dt, "2000-12-31T23:59:59", ii);
        }
        this.date(Token.substring(dt, 0, i), "2000-12-31T23:59:59", ii);
        this.time(Token.substring(dt, i + 1), "2000-12-31T23:59:59", ii);
    }

    public Dtm(Int tm, InputInfo ii) throws QueryException {
        this(Token.token(Util.formatDate(new Date(tm.itr()), FORMAT)), ii);
    }

    public Dtm(long tm, InputInfo ii) throws QueryException {
        this(Token.token(Util.formatDate(new Date(tm), FORMAT)), ii);
    }

    public Dtm(ADate d, Dur a, boolean p, InputInfo ii) throws QueryException {
        this(d);
        this.calc(a, p, ii);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Dtm)) {
            return false;
        }
        Dtm dtm = (Dtm)cmp;
        return this.type == dtm.type && this.xc.equals(dtm.xc);
    }

    public static long parse(String date) {
        try {
            return Util.parseDate(date, FORMAT).getTime();
        }
        catch (ParseException ex) {
            Util.errln(ex, new Object[0]);
            return 0L;
        }
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

