/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.io.in.BufferInput;
import org.basex.server.ClientSession;
import org.basex.server.Query;
import org.basex.server.ServerCmd;

public class ClientQuery
extends Query {
    protected final ClientSession cs;
    protected final String id;

    public ClientQuery(String query, ClientSession session, OutputStream os) throws IOException {
        this.cs = session;
        this.id = this.cs.exec(ServerCmd.QUERY, query, null);
        this.out = os;
    }

    @Override
    public String info() throws IOException {
        return this.cs.exec(ServerCmd.INFO, this.id, null);
    }

    @Override
    public String options() throws IOException {
        return this.cs.exec(ServerCmd.OPTIONS, this.id, null);
    }

    @Override
    public boolean updating() throws IOException {
        return Boolean.parseBoolean(this.cs.exec(ServerCmd.UPDATING, this.id, null));
    }

    @Override
    public void bind(String n, Object v, String t) throws IOException {
        this.cs.exec(ServerCmd.BIND, this.id + '\u0000' + n + '\u0000' + v + '\u0000' + (t == null ? "" : t), null);
    }

    @Override
    public void context(Object v, String t) throws IOException {
        this.cs.exec(ServerCmd.CONTEXT, this.id + '\u0000' + v + '\u0000' + (t == null ? "" : t), null);
    }

    @Override
    public String execute() throws IOException {
        return this.cs.exec(ServerCmd.EXEC, this.id, this.out);
    }

    @Override
    public void close() throws IOException {
        this.cs.exec(ServerCmd.CLOSE, this.id, null);
    }

    @Override
    protected void cache() throws IOException {
        this.cs.sout.write(ServerCmd.ITER.code);
        this.cs.send(this.id);
        this.cs.sout.flush();
        BufferInput bi = new BufferInput(this.cs.sin);
        this.cache(bi);
        if (!ClientSession.ok(bi)) {
            throw new BaseXException(bi.readString(), new Object[0]);
        }
    }
}

