/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class TokenSet
implements Iterable<byte[]> {
    protected static final int CAP = 8;
    public int size = 1;
    public byte[][] keys;
    private int[] next;
    private int[] bucket;

    public TokenSet() {
        this.keys = new byte[8][];
        this.next = new int[8];
        this.bucket = new int[8];
    }

    public TokenSet(byte[] token) {
        this();
        this.add(token);
    }

    public TokenSet(byte[] ... init) {
        this();
        for (byte[] i : init) {
            this.add(i);
        }
    }

    public TokenSet(DataInput in) throws IOException {
        this.read(in);
    }

    protected void read(DataInput in) throws IOException {
        this.keys = in.readTokens();
        this.next = in.readNums();
        this.bucket = in.readNums();
        this.size = in.readNum();
    }

    public void write(DataOutput out) throws IOException {
        out.writeTokens(this.keys);
        out.writeNums(this.next);
        out.writeNums(this.bucket);
        out.writeNum(this.size);
    }

    public final int add(byte[] key) {
        if (this.size == this.next.length) {
            this.rehash();
        }
        int p = Token.hash(key) & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                return -id;
            }
            id = this.next[id];
        }
        this.next[this.size] = this.bucket[p];
        this.keys[this.size] = key;
        this.bucket[p] = this.size;
        return this.size++;
    }

    public int delete(byte[] key) {
        int p = Token.hash(key) & this.bucket.length - 1;
        int o = 0;
        int id = this.bucket[p];
        while (id != 0) {
            int n = this.next[id];
            if (Token.eq(key, this.keys[id])) {
                if (this.bucket[p] == id) {
                    this.bucket[p] = n;
                } else {
                    this.next[o] = this.next[n];
                }
                this.keys[id] = null;
                return id;
            }
            o = id;
            id = n;
        }
        return 0;
    }

    public final boolean contains(byte[] key) {
        return this.id(key) != 0;
    }

    public final int id(byte[] key) {
        int p = Token.hash(key) & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final byte[] key(int i) {
        return this.keys[i];
    }

    public final byte[][] keys() {
        byte[][] tmp = new byte[this.size()][];
        System.arraycopy(this.keys, 1, tmp, 0, this.size - 1);
        return tmp;
    }

    public final int size() {
        return this.size - 1;
    }

    public final boolean isEmpty() {
        return this.size == 1;
    }

    protected void rehash() {
        int s = this.size << 1;
        int[] tmp = new int[s];
        for (int id : this.bucket) {
            while (id != 0) {
                int p = Token.hash(this.keys[id]) & s - 1;
                int nx = this.next[id];
                this.next[id] = tmp[p];
                tmp[p] = id;
                id = nx;
            }
        }
        this.bucket = tmp;
        this.next = Arrays.copyOf(this.next, s);
        byte[][] k = new byte[s][];
        System.arraycopy(this.keys, 0, k, 0, this.size);
        this.keys = k;
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private int c = 1;

            @Override
            public boolean hasNext() {
                return this.c < TokenSet.this.size;
            }

            @Override
            public byte[] next() {
                return TokenSet.this.keys[this.c++];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public String toString() {
        return new TokenBuilder(Util.name(this)).add(91).addSep((Object[])this.keys(), ", ").add(93).toString();
    }
}

